/*
 * Decompiled with CFR 0.152.
 */
package org.savantbuild.domain;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.savantbuild.domain.VersionException;

public class Version
implements Comparable<Version> {
    public static final String INTEGRATION = "{integration}";
    public final int major;
    public final String metaData;
    public final int minor;
    public final int patch;
    public final PreRelease preRelease;

    public Version() {
        this.major = 0;
        this.metaData = null;
        this.minor = 0;
        this.patch = 0;
        this.preRelease = null;
    }

    public Version(int major, int minor, int patch, PreRelease preRelease, String metaData) {
        if (major < 0 || minor < 0 || patch < 0) {
            throw new VersionException("Major, minor and patch must be positive integers");
        }
        this.major = major;
        this.minor = minor;
        this.patch = patch;
        this.preRelease = preRelease;
        this.metaData = metaData;
    }

    public Version(String version) {
        int i;
        char start = version.charAt(0);
        char end = version.charAt(version.length() - 1);
        if (start == '.' || start == '-' || start == '+' || end == '.' || end == '-' || end == '+') {
            throw new VersionException("Invalid Semantic Version string [" + version + "]. Version strings should not begin or end with . - or +");
        }
        StringBuilder num = new StringBuilder();
        Integer major = null;
        Integer minor = null;
        Integer patch = null;
        for (i = 0; i < version.length(); ++i) {
            char c = version.charAt(i);
            if (c == '.') {
                if (num.length() == 0) {
                    throw new VersionException("Invalid Semantic Version string [" + version + "]. Two version delimiters should not be next to each other.");
                }
                if (major == null) {
                    major = Integer.parseInt(num.toString());
                } else if (minor == null) {
                    minor = Integer.parseInt(num.toString());
                } else if (patch == null) {
                    patch = Integer.parseInt(num.toString());
                } else {
                    throw new VersionException("Invalid Semantic Version string [" + version + "]. A version can only have at most 3 dotted parts <major>.<minor>.<patch>");
                }
                num.setLength(0);
                continue;
            }
            if (c == '-' || c == '+') {
                if (num.length() != 0) break;
                throw new VersionException("Invalid Semantic Version string [" + version + "]. Two version delimiters should not be next to each other.");
            }
            if (Character.isDigit(c)) {
                num.append(c);
                continue;
            }
            throw new VersionException("Invalid Semantic Version string [" + version + "]. Alphabetic characters are not allowed in the initial version string.");
        }
        if (num.length() > 0) {
            if (major == null) {
                major = Integer.parseInt(num.toString());
            } else if (minor == null) {
                minor = Integer.parseInt(num.toString());
            } else if (patch == null) {
                patch = Integer.parseInt(num.toString());
            } else {
                throw new VersionException("Invalid Semantic Version string [" + version + "]. A version can only have at most 3 dotted parts <major>.<minor>.<patch>");
            }
        }
        int plus = version.indexOf(43, i);
        this.preRelease = i < version.length() && version.charAt(i) == '-' ? new PreRelease(plus == -1 ? version.substring(i + 1) : version.substring(i + 1, plus)) : null;
        this.metaData = plus != -1 ? version.substring(plus + 1) : null;
        this.major = major != null ? major : 0;
        this.minor = minor != null ? minor : 0;
        this.patch = patch != null ? patch : 0;
    }

    @Override
    public int compareTo(Version other) {
        int result = this.major - other.major;
        if (result == 0) {
            result = this.minor - other.minor;
        }
        if (result == 0) {
            result = this.patch - other.patch;
        }
        if (result == 0) {
            if (this.preRelease != null && other.preRelease != null) {
                result = this.preRelease.compareTo(other.preRelease);
            } else if (this.preRelease != null) {
                result = -1;
            } else if (other.preRelease != null) {
                result = 1;
            }
        }
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Version that = (Version)o;
        return this.major == that.major && this.minor == that.minor && this.patch == that.patch && (this.preRelease != null ? this.preRelease.equals(that.preRelease) : that.preRelease == null);
    }

    public int getMajor() {
        return this.major;
    }

    public String getMetaData() {
        return this.metaData;
    }

    public int getMinor() {
        return this.minor;
    }

    public int getPatch() {
        return this.patch;
    }

    public PreRelease getPreRelease() {
        return this.preRelease;
    }

    public int hashCode() {
        int result = this.major;
        result = 31 * result + this.minor;
        result = 31 * result + this.patch;
        result = 31 * result + (this.preRelease != null ? this.preRelease.hashCode() : 0);
        return result;
    }

    public boolean isCompatibleWith(Version other) {
        if (this.major == 0) {
            return this.minor == other.minor;
        }
        return this.major == other.major;
    }

    public boolean isIntegration() {
        return this.preRelease != null && this.preRelease.isIntegration();
    }

    public boolean isMajor() {
        return this.minor == 0 && this.patch == 0 && this.preRelease == null;
    }

    public boolean isMinor() {
        return this.minor > 0 && this.patch == 0 && this.preRelease == null;
    }

    public boolean isPatch() {
        return this.patch > 0 && this.preRelease == null;
    }

    public boolean isPreRelease() {
        return this.preRelease != null;
    }

    public Version toIntegrationVersion() {
        if (this.isIntegration()) {
            return this;
        }
        PreRelease integrationPreRelease = new PreRelease(new PreRelease.PreReleasePart[0]);
        if (this.preRelease != null) {
            integrationPreRelease.parts.addAll(this.preRelease.parts);
        }
        integrationPreRelease.parts.add(new PreRelease.PreReleasePart.StringPreReleasePart(INTEGRATION));
        return new Version(this.major, this.minor, this.patch, integrationPreRelease, this.metaData);
    }

    public String toString() {
        return "" + this.major + "." + this.minor + "." + this.patch + (this.preRelease != null ? "-" + this.preRelease : "") + (this.metaData != null ? "+" + this.metaData : "");
    }

    public static class PreRelease
    implements Comparable<PreRelease> {
        public final List<PreReleasePart> parts = new ArrayList<PreReleasePart>();

        public PreRelease(PreReleasePart ... parts) {
            Collections.addAll(this.parts, parts);
        }

        public PreRelease(String spec) {
            char start = spec.charAt(0);
            char end = spec.charAt(spec.length() - 1);
            if (start == '.' || start == '-' || start == '+' || end == '.' || end == '-' || end == '+') {
                throw new VersionException("Invalid Semantic Version PreRelease string [" + spec + "]. PreRelease Version strings should not begin or end with . - or +");
            }
            StringBuilder part = new StringBuilder();
            for (int i = 0; i < spec.length(); ++i) {
                char c = spec.charAt(i);
                if (c == '.') {
                    if (part.length() == 0) {
                        throw new VersionException("Invalid Semantic Version PreRelease string [" + spec + "]. Two version separators (.) should not be next to each other.");
                    }
                    if (part.toString().equals(Version.INTEGRATION)) {
                        throw new VersionException("Invalid Semantic Version PreRelease string [" + spec + "]. The {integration} indicator must be the last PreRelease part.");
                    }
                    this.addPart(part);
                    continue;
                }
                part.append(c);
            }
            this.addPart(part);
        }

        @Override
        public int compareTo(PreRelease o) {
            for (int i = 0; i < Integer.max(this.parts.size(), o.parts.size()); ++i) {
                PreReleasePart theirs;
                PreReleasePart mine = i < this.parts.size() ? this.parts.get(i) : null;
                PreReleasePart preReleasePart = theirs = i < o.parts.size() ? o.parts.get(i) : null;
                if (mine == null && theirs == null) {
                    return 0;
                }
                if (mine == null) {
                    return -1;
                }
                if (theirs == null) {
                    return 1;
                }
                int result = mine.compareTo(theirs);
                if (result == 0) continue;
                return result;
            }
            return 0;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PreRelease that = (PreRelease)o;
            return this.parts.equals(that.parts);
        }

        public int hashCode() {
            return this.parts.hashCode();
        }

        public boolean isIntegration() {
            return this.parts.size() > 0 && this.parts.get(this.parts.size() - 1).isIntegration();
        }

        public String toString() {
            return String.join((CharSequence)".", this.parts.stream().map(Object::toString).collect(Collectors.toList()));
        }

        private void addPart(StringBuilder part) {
            if (part.length() == 0) {
                return;
            }
            String partStr = part.toString();
            try {
                int value = Integer.parseInt(partStr);
                this.parts.add(new PreReleasePart.NumberPreReleasePart(value));
            }
            catch (NumberFormatException e) {
                this.parts.add(new PreReleasePart.StringPreReleasePart(partStr));
            }
            part.setLength(0);
        }

        public static interface PreReleasePart
        extends Comparable<PreReleasePart> {
            public boolean isIntegration();

            public boolean isNumber();

            public static class StringPreReleasePart
            implements PreReleasePart {
                public final String value;

                public StringPreReleasePart(String value) {
                    this.value = value;
                }

                @Override
                public int compareTo(PreReleasePart o) {
                    if (o instanceof NumberPreReleasePart) {
                        return 1;
                    }
                    return this.value.compareTo(((StringPreReleasePart)o).value);
                }

                public boolean equals(Object o) {
                    if (this == o) {
                        return true;
                    }
                    if (o == null || this.getClass() != o.getClass()) {
                        return false;
                    }
                    StringPreReleasePart that = (StringPreReleasePart)o;
                    return this.value.equals(that.value);
                }

                public int hashCode() {
                    return this.value.hashCode();
                }

                @Override
                public boolean isIntegration() {
                    return this.value.equals(Version.INTEGRATION);
                }

                @Override
                public boolean isNumber() {
                    return false;
                }

                public String toString() {
                    return this.value;
                }
            }

            public static class NumberPreReleasePart
            implements PreReleasePart {
                public final int value;

                public NumberPreReleasePart(int value) {
                    this.value = value;
                }

                @Override
                public int compareTo(PreReleasePart o) {
                    if (o instanceof StringPreReleasePart) {
                        return -1;
                    }
                    return this.value - ((NumberPreReleasePart)o).value;
                }

                public boolean equals(Object o) {
                    if (this == o) {
                        return true;
                    }
                    if (o == null || this.getClass() != o.getClass()) {
                        return false;
                    }
                    NumberPreReleasePart that = (NumberPreReleasePart)o;
                    return this.value == that.value;
                }

                public int hashCode() {
                    return this.value;
                }

                @Override
                public boolean isIntegration() {
                    return false;
                }

                @Override
                public boolean isNumber() {
                    return true;
                }

                public String toString() {
                    return "" + this.value;
                }
            }
        }
    }
}

