/*
 * Decompiled with CFR 0.152.
 */
package org.savantbuild.security;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import org.savantbuild.lang.StringTools;
import org.savantbuild.security.MD5;
import org.savantbuild.security.MD5Exception;

public class MD5Tools {
    public static MD5 write(InputStream is, OutputStream os, MD5 md5) throws IOException {
        byte[] localMD5;
        MessageDigest digest;
        try {
            digest = MessageDigest.getInstance("MD5");
            digest.reset();
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("Unable to locate MD5 algorithm");
        }
        DigestInputStream inputStream = new DigestInputStream(new BufferedInputStream(is), digest);
        inputStream.on(true);
        try (BufferedOutputStream bof = new BufferedOutputStream(os);){
            int len;
            byte[] b = new byte[8192];
            while ((len = inputStream.read(b)) != -1) {
                bof.write(b, 0, len);
            }
        }
        if (md5 != null && md5.bytes != null && (localMD5 = digest.digest()) != null && !Arrays.equals(localMD5, md5.bytes)) {
            throw new MD5Exception("MD5 mismatch when writing from the InputStream to the OutputStream. Expected MD5 [" + StringTools.toHex(md5.bytes) + "] but was [" + StringTools.toHex(localMD5) + "]");
        }
        byte[] bytes = inputStream.getMessageDigest().digest();
        return new MD5(StringTools.toHex(bytes), bytes, null);
    }
}

