/*
 * Decompiled with CFR 0.152.
 */
package org.savantbuild.net;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.nio.file.Path;
import java.util.Base64;
import javax.net.ssl.HttpsURLConnection;
import org.savantbuild.security.MD5;
import org.savantbuild.security.MD5Exception;
import org.savantbuild.security.MD5Tools;

public class NetTools {
    public static URI build(String ... parts) throws URISyntaxException {
        StringBuilder build = new StringBuilder(parts[0]);
        for (int i = 1; i < parts.length; ++i) {
            String[] splits;
            boolean endSlash = build.charAt(build.length() - 1) == '/';
            boolean startSlash = parts[i].startsWith("/");
            if (!endSlash && !startSlash) {
                build.append("/");
            }
            String part = parts[i];
            if (endSlash && startSlash) {
                part = parts[i].substring(1);
            }
            boolean first = true;
            for (String split : splits = part.split("/")) {
                if (!first) {
                    build.append("/");
                } else {
                    first = false;
                }
                try {
                    build.append(URLEncoder.encode(split, "UTF-8"));
                }
                catch (UnsupportedEncodingException e) {
                    throw new IllegalStateException("The JVM doesn't have UTF-8", e);
                }
            }
        }
        return new URI(build.toString());
    }

    public static Path downloadToPath(URI uri, String username, String password, MD5 md5) throws IOException, MD5Exception {
        HttpURLConnection huc;
        URLConnection uc = uri.toURL().openConnection();
        if (uc instanceof HttpURLConnection) {
            huc = (HttpURLConnection)uc;
            if (username != null) {
                String credentials = username + ":" + password;
                huc.setRequestProperty("Authorization", "Basic " + Base64.getEncoder().encodeToString(credentials.getBytes()));
            }
            huc.setInstanceFollowRedirects(true);
        }
        if (uc instanceof HttpsURLConnection) {
            huc = (HttpsURLConnection)uc;
            ((HttpsURLConnection)huc).setHostnameVerifier((s, sslSession) -> true);
        }
        uc.setConnectTimeout(4000);
        uc.setReadTimeout(10000);
        uc.setDoInput(true);
        uc.setDoOutput(false);
        uc.connect();
        if (uc instanceof HttpURLConnection) {
            huc = (HttpURLConnection)uc;
            int result = huc.getResponseCode();
            if (result != 200 && result != 404 && result != 410) {
                throw new IOException("HTTP sent an unexpected response code [" + result + "]");
            }
            if (result == 404 || result == 410) {
                return null;
            }
        }
        File file = File.createTempFile("savant-net-tools", "download");
        file.deleteOnExit();
        try (InputStream is = uc.getInputStream();
             FileOutputStream os = new FileOutputStream(file);){
            MD5Tools.write(is, os, md5);
            os.flush();
        }
        return file.toPath();
    }
}

