/*
 * Decompiled with CFR 0.152.
 */
package org.savantbuild.dep.workflow.process;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Objects;
import org.savantbuild.dep.domain.Artifact;
import org.savantbuild.dep.workflow.PublishWorkflow;
import org.savantbuild.dep.workflow.process.Process;
import org.savantbuild.dep.workflow.process.ProcessFailureException;
import org.savantbuild.net.NetTools;
import org.savantbuild.output.Output;
import org.savantbuild.security.MD5;
import org.savantbuild.security.MD5Exception;

public class URLProcess
implements Process {
    public final Output output;
    public final String password;
    public final String url;
    public final String username;

    public URLProcess(Output output, String url, String username, String password) {
        this.output = output;
        Objects.requireNonNull(url, "The [url] attribute is required for the [url] workflow process");
        if (username != null || password != null) {
            Objects.requireNonNull(username, "You must specify both the [username] and [password] attributes to turn on authentication for the [url] workflow process.");
            Objects.requireNonNull(password, "You must specify both the [username] and [password] attributes to turn on authentication for the [url] workflow process.");
        }
        this.url = url;
        this.username = username;
        this.password = password;
    }

    @Override
    public void deleteIntegrationBuilds(Artifact artifact) throws ProcessFailureException {
        throw new ProcessFailureException(artifact, "The [url] process doesn't support deleting integration builds.");
    }

    @Override
    public Path fetch(Artifact artifact, String item, PublishWorkflow publishWorkflow) throws ProcessFailureException {
        try {
            Path itemFile;
            MD5 md5;
            URI md5URI = NetTools.build((String[])new String[]{this.url, artifact.id.group.replace('.', '/'), artifact.id.project, artifact.version.toString(), item + ".md5"});
            Path md5File = NetTools.downloadToPath((URI)md5URI, (String)this.username, (String)this.password, null);
            if (md5File == null) {
                return null;
            }
            try {
                md5 = MD5.load((Path)md5File);
            }
            catch (IOException e) {
                Files.delete(md5File);
                throw new ProcessFailureException(artifact, (Throwable)e);
            }
            URI itemURI = NetTools.build((String[])new String[]{this.url, artifact.id.group.replace('.', '/'), artifact.id.project, artifact.version.toString(), item});
            try {
                itemFile = NetTools.downloadToPath((URI)itemURI, (String)this.username, (String)this.password, (MD5)md5);
            }
            catch (MD5Exception e) {
                throw new MD5Exception("MD5 mismatch when fetching item from [" + itemURI + "]");
            }
            if (itemFile != null) {
                this.output.infoln("Downloaded from [%s]", new Object[]{itemURI});
                md5File = publishWorkflow.publish(artifact, item + ".md5", md5File);
                try {
                    itemFile = publishWorkflow.publish(artifact, item, itemFile);
                }
                catch (ProcessFailureException e) {
                    Files.delete(md5File);
                    throw new ProcessFailureException(artifact, (Throwable)e);
                }
            }
            return itemFile;
        }
        catch (FileNotFoundException e) {
            return null;
        }
        catch (IOException | URISyntaxException e) {
            throw new ProcessFailureException(artifact, (Throwable)e);
        }
    }

    @Override
    public Path publish(Artifact artifact, String item, Path file) throws ProcessFailureException {
        throw new ProcessFailureException(artifact, "The [url] process doesn't allow publishing.");
    }

    public String toString() {
        return "URL(" + this.url + ")";
    }
}

