/*
 * Decompiled with CFR 0.152.
 */
package org.savantbuild.dep.workflow.process;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Objects;
import org.savantbuild.dep.PathTools;
import org.savantbuild.dep.domain.Artifact;
import org.savantbuild.dep.workflow.PublishWorkflow;
import org.savantbuild.dep.workflow.process.Process;
import org.savantbuild.dep.workflow.process.ProcessFailureException;
import org.savantbuild.lang.RuntimeTools;
import org.savantbuild.net.NetTools;
import org.savantbuild.output.Output;
import org.savantbuild.security.MD5;
import org.savantbuild.security.MD5Exception;

public class SVNProcess
implements Process {
    public final Output output;
    public final String password;
    public final String repository;
    public final String username;

    public SVNProcess(Output output, String repository, String username, String password) {
        this.output = output;
        Objects.requireNonNull(repository, "The [repository] attribute is required for the [svn] workflow process");
        if (username != null || password != null) {
            Objects.requireNonNull(username, "You must specify both the [username] and [password] attributes to turn on authentication for the [svn] workflow process.");
            Objects.requireNonNull(password, "You must specify both the [username] and [password] attributes to turn on authentication for the [svn] workflow process.");
        }
        this.repository = repository;
        this.username = username;
        this.password = password;
    }

    @Override
    public void deleteIntegrationBuilds(Artifact artifact) throws ProcessFailureException {
        throw new ProcessFailureException(artifact, "The [svn] process doesn't allow deleting of integration builds.");
    }

    @Override
    public Path fetch(Artifact artifact, String item, PublishWorkflow publishWorkflow) throws ProcessFailureException {
        try {
            MD5 md5;
            Path md5File = PathTools.createTempPath("savant-svn-process", "export", true);
            URI md5URI = NetTools.build((String[])new String[]{this.repository, artifact.id.group.replace('.', '/'), artifact.id.project, artifact.version.toString(), item + ".md5"});
            if (!this.export(md5URI, md5File)) {
                return null;
            }
            try {
                md5 = MD5.load((Path)md5File);
            }
            catch (IOException e) {
                Files.delete(md5File);
                throw new ProcessFailureException(artifact, (Throwable)e);
            }
            Path itemFile = PathTools.createTempPath("savant-svn-process", "export", true);
            URI itemURI = NetTools.build((String[])new String[]{this.repository, artifact.id.group.replace('.', '/'), artifact.id.project, artifact.version.toString(), item});
            if (!this.export(itemURI, itemFile)) {
                return null;
            }
            MD5 itemMD5 = MD5.forPath((Path)itemFile);
            if (!itemMD5.equals((Object)md5)) {
                throw new MD5Exception("MD5 mismatch when fetching item from [" + itemURI.toString() + "]");
            }
            this.output.infoln("Downloaded from SubVersion at [%s]", new Object[]{itemURI});
            md5File = publishWorkflow.publish(artifact, item + ".md5", md5File);
            try {
                itemFile = publishWorkflow.publish(artifact, item, itemFile);
            }
            catch (ProcessFailureException e) {
                Files.delete(md5File);
                throw new ProcessFailureException(artifact, (Throwable)e);
            }
            return itemFile;
        }
        catch (IOException | InterruptedException | URISyntaxException e) {
            throw new ProcessFailureException(artifact, (Throwable)e);
        }
    }

    @Override
    public Path publish(Artifact artifact, String item, Path artifactFile) throws ProcessFailureException {
        try {
            URI uri = NetTools.build((String[])new String[]{this.repository, artifact.id.group.replace('.', '/'), artifact.id.project, artifact.version.toString(), item});
            if (!this.imprt(uri, artifactFile)) {
                throw new ProcessFailureException(artifact, "Unable to publish artifact item [" + item + "] to [" + uri + "]");
            }
            this.output.infoln("Published to SubVersion at [%s]", new Object[]{uri});
            return null;
        }
        catch (IOException | InterruptedException | URISyntaxException e) {
            throw new ProcessFailureException(artifact, (Throwable)e);
        }
    }

    private boolean export(URI uri, Path file) throws IOException, InterruptedException {
        RuntimeTools.ProcessResult result = this.username != null ? RuntimeTools.exec((String[])new String[]{"svn", "export", "--force", "--non-interactive", "--no-auth-cache", "--username", this.username, "--password", this.password, uri.toString(), file.toAbsolutePath().toString()}) : RuntimeTools.exec((String[])new String[]{"svn", "export", "--force", "--non-interactive", "--no-auth-cache", uri.toString(), file.toAbsolutePath().toString()});
        this.output.debugln(result.output, new Object[0]);
        return result.exitCode == 0;
    }

    private boolean imprt(URI uri, Path file) throws IOException, InterruptedException {
        RuntimeTools.ProcessResult result = this.username != null ? RuntimeTools.exec((String[])new String[]{"svn", "import", "--non-interactive", "--no-auth-cache", "-m", "Published artifact", "--username", this.username, "--password", this.password, file.toAbsolutePath().toString(), uri.toString()}) : RuntimeTools.exec((String[])new String[]{"svn", "import", "--non-interactive", "--no-auth-cache", "-m", "Published artifact", file.toAbsolutePath().toString(), uri.toString()});
        this.output.debugln(result.output, new Object[0]);
        return result.exitCode == 0;
    }

    public String toString() {
        return "SVN(" + this.repository + ")";
    }
}

