/*
 * Decompiled with CFR 0.152.
 */
package org.savantbuild.dep.workflow;

import java.io.IOException;
import java.nio.file.Path;
import javax.xml.parsers.ParserConfigurationException;
import org.savantbuild.dep.domain.Artifact;
import org.savantbuild.dep.domain.ArtifactMetaData;
import org.savantbuild.dep.workflow.ArtifactMetaDataMissingException;
import org.savantbuild.dep.workflow.ArtifactMissingException;
import org.savantbuild.dep.workflow.FetchWorkflow;
import org.savantbuild.dep.workflow.PublishWorkflow;
import org.savantbuild.dep.workflow.process.NegativeCacheException;
import org.savantbuild.dep.workflow.process.ProcessFailureException;
import org.savantbuild.dep.xml.ArtifactTools;
import org.savantbuild.domain.VersionException;
import org.savantbuild.security.MD5Exception;
import org.xml.sax.SAXException;

public class Workflow {
    public final FetchWorkflow fetchWorkflow;
    public final PublishWorkflow publishWorkflow;

    public Workflow(FetchWorkflow fetchWorkflow, PublishWorkflow publishWorkflow) {
        this.fetchWorkflow = fetchWorkflow;
        this.publishWorkflow = publishWorkflow;
    }

    public Path fetchArtifact(Artifact artifact) throws ArtifactMissingException, ProcessFailureException, MD5Exception {
        Path file = this.fetchWorkflow.fetchItem(artifact, artifact.getArtifactFile(), this.publishWorkflow);
        if (file == null) {
            throw new ArtifactMissingException(artifact);
        }
        return file;
    }

    public ArtifactMetaData fetchMetaData(Artifact artifact) throws ArtifactMetaDataMissingException, ProcessFailureException, MD5Exception {
        Path file = this.fetchWorkflow.fetchItem(artifact, artifact.getArtifactMetaDataFile(), this.publishWorkflow);
        if (file == null) {
            throw new ArtifactMetaDataMissingException(artifact);
        }
        try {
            return ArtifactTools.parseArtifactMetaData(file);
        }
        catch (IOException | IllegalArgumentException | NullPointerException | ParserConfigurationException | VersionException | SAXException e) {
            throw new ProcessFailureException(artifact, e);
        }
    }

    public Path fetchSource(Artifact artifact) throws ProcessFailureException, MD5Exception {
        try {
            Path file = this.fetchWorkflow.fetchItem(artifact, artifact.getArtifactSourceFile(), this.publishWorkflow);
            if (file == null) {
                this.publishWorkflow.publishNegative(artifact, artifact.getArtifactSourceFile());
            }
            return file;
        }
        catch (NegativeCacheException e) {
            return null;
        }
    }
}

