/*
 * Decompiled with CFR 0.152.
 */
package org.savantbuild.dep.graph;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.savantbuild.dep.domain.License;
import org.savantbuild.domain.Version;

public class DependencyEdgeValue {
    public final Version dependencyVersion;
    public final Version dependentVersion;
    public final List<License> licenses;
    public final String type;

    public DependencyEdgeValue(Version dependentVersion, Version dependencyVersion, String type, License ... licenses) {
        this(dependentVersion, dependencyVersion, type, Arrays.asList(licenses));
    }

    public DependencyEdgeValue(Version dependentVersion, Version dependencyVersion, String type, List<License> licenses) {
        Objects.requireNonNull(dependentVersion, "DependencyEdgeValue requires a dependentVersion");
        Objects.requireNonNull(dependencyVersion, "DependencyEdgeValue requires a dependencyVersion");
        Objects.requireNonNull(type, "DependencyEdgeValue requires a type");
        Objects.requireNonNull(licenses, "DependencyEdgeValue requires a license");
        this.dependentVersion = dependentVersion;
        this.dependencyVersion = dependencyVersion;
        this.type = type;
        this.licenses = licenses;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DependencyEdgeValue that = (DependencyEdgeValue)o;
        return this.dependencyVersion.equals((Object)that.dependencyVersion) && this.dependentVersion.equals((Object)that.dependentVersion) && this.type.equals(that.type) && this.licenses.equals(that.licenses);
    }

    public int hashCode() {
        int result = this.dependencyVersion.hashCode();
        result = 31 * result + this.dependentVersion.hashCode();
        result = 31 * result + this.type.hashCode();
        return result;
    }

    public String toString() {
        return this.dependentVersion + " ---(type=" + this.type + ",licenses=" + this.licenses + ")--> " + this.dependencyVersion;
    }
}

