/*
 * Decompiled with CFR 0.152.
 */
package org.savantbuild.dep.domain;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.savantbuild.dep.domain.Artifact;
import org.savantbuild.dep.domain.ArtifactID;
import org.savantbuild.dep.domain.License;
import org.savantbuild.domain.Version;

public class ReifiedArtifact
extends Artifact {
    public final List<License> licenses;

    public ReifiedArtifact(ArtifactID id, Version version, License ... licenses) {
        this(id, version, Arrays.asList(licenses));
    }

    public ReifiedArtifact(ArtifactID id, Version version, List<License> licenses) {
        super(id, version, false);
        Objects.requireNonNull(licenses, "Artifacts must have a license");
        this.licenses = licenses;
    }

    public ReifiedArtifact(String spec, License ... licenses) {
        this(spec, Arrays.asList(licenses));
    }

    public ReifiedArtifact(String spec, List<License> licenses) {
        super(spec, false);
        Objects.requireNonNull(licenses, "Artifacts must have a license");
        this.licenses = licenses;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ReifiedArtifact that = (ReifiedArtifact)o;
        return this.licenses.equals(that.licenses);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.licenses.hashCode();
        return result;
    }
}

