/*
 * Decompiled with CFR 0.152.
 */
package org.savantbuild.dep.domain;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.savantbuild.dep.LicenseException;
import org.savantbuild.dep.domain.LicenseTextException;

@JsonIgnoreProperties(ignoreUnknown=true)
public final class License {
    public static final Set<String> CustomLicenses;
    public static final Map<String, LicenseTextException> Exceptions;
    public static final Map<String, License> Licenses;
    @JsonProperty(value="detailsUrl")
    public String detailsURL;
    public LicenseTextException exception;
    @JsonProperty(value="isFsfLibre")
    public boolean fsfLibre;
    @JsonProperty(value="licenseId")
    public String identifier;
    public String name;
    @JsonProperty(value="isOsiApproved")
    public boolean osiApproved;
    public String reference;
    public List<String> seeAlso;
    public String text;

    public License() {
    }

    public License(String identifier, String text) {
        boolean badId;
        boolean bl = badId = !CustomLicenses.contains(identifier) && !Licenses.containsKey(identifier);
        if (text == null || text.trim().isEmpty() || badId) {
            throw new LicenseException(identifier);
        }
        this.identifier = identifier;
        this.text = text;
    }

    public License(License other) {
        this.detailsURL = other.detailsURL;
        this.exception = other.exception;
        this.fsfLibre = other.fsfLibre;
        this.identifier = other.identifier;
        this.name = other.name;
        this.osiApproved = other.osiApproved;
        this.reference = other.reference;
        this.seeAlso = other.seeAlso;
        this.text = other.text;
    }

    public License(License other, LicenseTextException exception) {
        this(other);
        this.exception = exception;
    }

    public static License parse(String identifier, String text) {
        if (text != null) {
            return new License(identifier, text);
        }
        if (CustomLicenses.contains(identifier)) {
            throw new LicenseException(identifier);
        }
        String[] parts = identifier.split("\\s+WITH\\s+");
        License license = Licenses.get(parts[0]);
        if (license == null) {
            throw new LicenseException(parts[0]);
        }
        LicenseTextException exception = null;
        if (parts.length == 2 && (exception = Exceptions.get(parts[1])) == null) {
            throw new LicenseException(parts[1]);
        }
        return exception != null ? new License(license, exception) : license;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof License)) {
            return false;
        }
        License license = (License)o;
        return Objects.equals(this.identifier, license.identifier);
    }

    public int hashCode() {
        return Objects.hash(this.identifier);
    }

    /*
     * Exception decompiling
     */
    static {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    private static class Licenses {
        public List<License> licenses = new ArrayList<License>();

        private Licenses() {
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    private static class LicenseText {
        public String licenseText;

        private LicenseText() {
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    private static class LicenseExceptions {
        public List<LicenseTextException> exceptions = new ArrayList<LicenseTextException>();

        private LicenseExceptions() {
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    private static class LicenseExceptionText {
        public String licenseExceptionText;

        private LicenseExceptionText() {
        }
    }
}

