/*
 * Decompiled with CFR 0.152.
 */
package org.savantbuild.dep.domain;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.savantbuild.dep.domain.Artifact;

public class DependencyGroup {
    public final List<Artifact> dependencies = new ArrayList<Artifact>();
    public final boolean export;
    public final String name;

    public DependencyGroup(String name, boolean export, Artifact ... dependencies) throws NullPointerException {
        Objects.requireNonNull(name, "DependencyGroups must have a type specified (i.e. compile, run, test, etc.)");
        this.name = name;
        this.export = export;
        Collections.addAll(this.dependencies, dependencies);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DependencyGroup that = (DependencyGroup)o;
        return this.export == that.export && this.dependencies.equals(that.dependencies) && this.name.equals(that.name);
    }

    public int hashCode() {
        int result = this.dependencies.hashCode();
        result = 31 * result + this.name.hashCode();
        result = 31 * result + (this.export ? 1 : 0);
        return result;
    }
}

