/*
 * Decompiled with CFR 0.152.
 */
package org.savantbuild.dep.domain;

import java.util.Arrays;
import java.util.List;
import org.savantbuild.dep.domain.Artifact;
import org.savantbuild.dep.domain.Dependencies;
import org.savantbuild.dep.domain.License;
import org.savantbuild.dep.domain.ReifiedArtifact;

public class ArtifactMetaData {
    public final Dependencies dependencies;
    public final List<License> licenses;

    public ArtifactMetaData(Dependencies dependencies, License ... licenses) {
        this(dependencies, Arrays.asList(licenses));
    }

    public ArtifactMetaData(Dependencies dependencies, List<License> licenses) {
        this.dependencies = dependencies;
        this.licenses = licenses;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ArtifactMetaData that = (ArtifactMetaData)o;
        return this.dependencies.equals(that.dependencies) && this.licenses.equals(that.licenses);
    }

    public int hashCode() {
        int result = this.dependencies.hashCode();
        result = 31 * result + this.licenses.hashCode();
        return result;
    }

    public ReifiedArtifact toLicensedArtifact(Artifact dependency) {
        return new ReifiedArtifact(dependency.id, dependency.version, this.licenses);
    }
}

