/*
 * Decompiled with CFR 0.152.
 */
package org.savantbuild.dep.domain;

import java.util.Objects;

public class ArtifactID
implements Comparable<ArtifactID> {
    public final String group;
    public final String name;
    public final String project;
    public final String type;

    public ArtifactID(String group, String project, String name, String type) throws NullPointerException {
        Objects.requireNonNull(group, "Artifacts must have a group");
        Objects.requireNonNull(project, "Artifacts must have a project");
        Objects.requireNonNull(name, "Artifacts must have a name");
        Objects.requireNonNull(type, "Artifacts must have a type");
        this.group = group;
        this.project = project == null ? name : project;
        this.name = name == null ? project : name;
        this.type = type == null ? "jar" : type;
    }

    @Override
    public int compareTo(ArtifactID other) {
        Objects.requireNonNull(other);
        int diff = this.group.compareTo(other.group);
        if (diff == 0) {
            diff = this.name.compareTo(other.name);
        }
        if (diff == 0) {
            diff = this.project.compareTo(other.project);
        }
        if (diff == 0) {
            diff = this.type.compareTo(other.type);
        }
        return diff;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ArtifactID that = (ArtifactID)o;
        return this.group.equals(that.group) && this.name.equals(that.name) && this.project.equals(that.project) && this.type.equals(that.type);
    }

    public int hashCode() {
        int result = this.group.hashCode();
        result = 31 * result + this.project.hashCode();
        result = 31 * result + this.name.hashCode();
        result = 31 * result + this.type.hashCode();
        return result;
    }

    public String toString() {
        return this.group + ":" + this.project + ":" + this.name + ":" + this.type;
    }
}

