/*
 * Decompiled with CFR 0.152.
 */
package org.savantbuild.dep.domain;

import java.util.Arrays;
import java.util.Objects;
import org.savantbuild.dep.domain.ArtifactID;
import org.savantbuild.domain.Version;

public class Artifact {
    public final ArtifactID id;
    public final boolean skipCompatibilityCheck;
    public final Version version;

    public Artifact(ArtifactID id, Version version, boolean skipCompatibilityCheck) {
        Objects.requireNonNull(id, "Artifacts must have an ArtifactID");
        Objects.requireNonNull(version, "Artifacts must have a Version");
        this.id = id;
        this.skipCompatibilityCheck = skipCompatibilityCheck;
        this.version = version;
    }

    public Artifact(String spec, boolean skipCompatibilityCheck) {
        this.skipCompatibilityCheck = skipCompatibilityCheck;
        String[] parts = spec.split(":");
        if (parts.length < 3) {
            throw new IllegalArgumentException("Invalid artifact specification [" + spec + "]. It must have 3, 4, or 5 parts");
        }
        if (Arrays.stream(parts).filter(String::isEmpty).count() > 0L) {
            throw new IllegalArgumentException("Invalid artifact specification [" + spec + "]. One of the parts is empty (i.e. foo::3.0");
        }
        if (parts.length == 3) {
            this.id = new ArtifactID(parts[0], parts[1], parts[1], "jar");
            this.version = new Version(parts[2]);
        } else if (parts.length == 4) {
            this.id = new ArtifactID(parts[0], parts[1], parts[1], parts[3]);
            this.version = new Version(parts[2]);
        } else if (parts.length == 5) {
            this.id = new ArtifactID(parts[0], parts[1], parts[2], parts[4]);
            this.version = new Version(parts[3]);
        } else {
            throw new IllegalArgumentException("Invalid artifact specification [" + spec + "]. It must have 3, 4, or 5 parts");
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof Artifact)) {
            return false;
        }
        Artifact artifact = (Artifact)o;
        return this.id.equals(artifact.id) && this.version.equals((Object)artifact.version);
    }

    public String getArtifactFile() {
        return this.prefix() + "." + this.id.type;
    }

    public String getArtifactMetaDataFile() {
        return this.prefix() + "." + this.id.type + ".amd";
    }

    public String getArtifactSourceFile() {
        return this.prefix() + "-src." + this.id.type;
    }

    public String getArtifactTestFile() {
        return this.id.name + "-test-" + this.version + "." + this.id.type;
    }

    public String getArtifactTestSourceFile() {
        return this.id.name + "-test-" + this.version + "-src." + this.id.type;
    }

    public int hashCode() {
        int result = this.id.hashCode();
        result = 31 * result + this.version.hashCode();
        return result;
    }

    public boolean isIntegrationBuild() {
        return this.version.isIntegration();
    }

    public String toString() {
        return this.id.group + ":" + this.id.project + ":" + this.id.name + ":" + this.version + ":" + this.id.type;
    }

    private String prefix() {
        return this.id.name + "-" + this.version;
    }
}

