/*
 * Decompiled with CFR 0.152.
 */
package org.savantbuild.dep;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;

public class PathTools {
    public static Path createTempPath(String prefix, String suffix, boolean deleteOnExit) throws IOException {
        File file = File.createTempFile(prefix, suffix);
        if (deleteOnExit) {
            file.deleteOnExit();
        }
        return file.toPath();
    }

    public static void prune(Path path) throws IOException {
        if (!Files.exists(path, new LinkOption[0])) {
            return;
        }
        if (Files.isSymbolicLink(path)) {
            Files.delete(path);
            return;
        }
        Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                Files.delete(dir);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                Files.delete(file);
                return FileVisitResult.CONTINUE;
            }
        });
    }
}

