/*
 * Decompiled with CFR 0.152.
 */
package org.savantbuild.dep;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.savantbuild.dep.DependencyListener;
import org.savantbuild.dep.LicenseException;
import org.savantbuild.dep.PublishException;
import org.savantbuild.dep.domain.CompatibilityException;
import org.savantbuild.dep.domain.Dependencies;
import org.savantbuild.dep.domain.License;
import org.savantbuild.dep.domain.Publication;
import org.savantbuild.dep.domain.ReifiedArtifact;
import org.savantbuild.dep.graph.ArtifactGraph;
import org.savantbuild.dep.graph.DependencyGraph;
import org.savantbuild.dep.graph.ResolvedArtifactGraph;
import org.savantbuild.dep.workflow.ArtifactMetaDataMissingException;
import org.savantbuild.dep.workflow.ArtifactMissingException;
import org.savantbuild.dep.workflow.PublishWorkflow;
import org.savantbuild.dep.workflow.Workflow;
import org.savantbuild.dep.workflow.process.ProcessFailureException;
import org.savantbuild.security.MD5Exception;
import org.savantbuild.util.CyclicException;

public interface DependencyService {
    public DependencyGraph buildGraph(ReifiedArtifact var1, Dependencies var2, Workflow var3) throws ArtifactMetaDataMissingException, ProcessFailureException, MD5Exception;

    public void publish(Publication var1, PublishWorkflow var2) throws PublishException;

    public ArtifactGraph reduce(DependencyGraph var1) throws CompatibilityException, CyclicException;

    public ResolvedArtifactGraph resolve(ArtifactGraph var1, Workflow var2, TraversalRules var3, DependencyListener ... var4) throws CyclicException, ArtifactMissingException, ProcessFailureException, MD5Exception, LicenseException;

    public static class TraversalRules {
        public Map<String, GroupTraversalRule> rules = new HashMap<String, GroupTraversalRule>();

        public String toString() {
            StringBuilder build = new StringBuilder();
            this.rules.forEach((key, value) -> build.append("  [group: \"").append((String)key).append("\", fetchSource: ").append(value.fetchSource).append(", transitive: ").append(value.transitive).append(", transitiveGroups: ").append(value.transitiveGroups).append("]\n"));
            return build.toString();
        }

        public TraversalRules with(String group, GroupTraversalRule groupTraversalRule) {
            this.rules.put(group, groupTraversalRule);
            return this;
        }

        public static class GroupTraversalRule {
            public Set<License> disallowedLicenses = new HashSet<License>();
            public boolean fetchSource;
            public boolean transitive;
            public Set<String> transitiveGroups = new HashSet<String>();

            public GroupTraversalRule(boolean fetchSource, boolean transitive) {
                this.fetchSource = fetchSource;
                this.transitive = transitive;
            }

            public GroupTraversalRule(boolean fetchSource, boolean transitive, License ... disallowedLicenses) {
                Collections.addAll(this.disallowedLicenses, disallowedLicenses);
                this.fetchSource = fetchSource;
                this.transitive = transitive;
            }

            public GroupTraversalRule(boolean fetchSource, String ... transitiveGroups) {
                Collections.addAll(this.transitiveGroups, transitiveGroups);
                this.fetchSource = fetchSource;
                this.transitive = true;
            }

            public GroupTraversalRule(boolean fetchSource, boolean transitive, Collection<String> transitiveGroups) {
                this.fetchSource = fetchSource;
                this.transitive = transitive;
                if (transitive) {
                    this.transitiveGroups.addAll(transitiveGroups);
                }
            }

            public GroupTraversalRule withDisallowedLicenses(License ... disallowedLicenses) {
                Collections.addAll(this.disallowedLicenses, disallowedLicenses);
                return this;
            }

            public GroupTraversalRule withFetchSource(boolean fetchSource) {
                this.fetchSource = fetchSource;
                return this;
            }

            public GroupTraversalRule withTransitive(boolean transitive) {
                this.transitive = transitive;
                return this;
            }

            public GroupTraversalRule withTransitiveGroups(String ... transitiveGroups) {
                Collections.addAll(this.transitiveGroups, transitiveGroups);
                return this;
            }
        }
    }
}

