/*
 * Decompiled with CFR 0.152.
 */
package org.savantbuild.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.savantbuild.util.CyclicException;
import org.savantbuild.util.Graph;

public class HashGraph<T, U>
implements Graph<T, U> {
    private final Map<T, HashNode<T, U>> nodes = new LinkedHashMap<T, HashNode<T, U>>();

    @Override
    public void addEdge(T origin, T destination, U value) {
        HashNode<T, U> originNode = this.addNode(origin);
        HashNode<T, U> destinationNode = this.addNode(destination);
        originNode.addOutboundEdge(destinationNode, value);
        destinationNode.addInboundEdge(originNode, value);
    }

    @Override
    public boolean contains(T value) {
        return this.nodes.containsKey(value);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HashGraph hashGraph = (HashGraph)o;
        return this.nodes.equals(hashGraph.nodes);
    }

    @Override
    public T find(T rootValue, Predicate<T> predicate) throws CyclicException {
        HashNode<T, U> rootNode = this.nodes.get(rootValue);
        if (rootNode == null) {
            return null;
        }
        HashSet visited = new HashSet();
        return this.find(rootNode, visited, predicate);
    }

    @Override
    public List<Graph.Edge<T, U>> getInboundEdges(T value) {
        HashNode<T, U> node = this.nodes.get(value);
        if (node == null) {
            return null;
        }
        return node.inbound.stream().map(HashEdge::toEdge).collect(Collectors.toList());
    }

    @Override
    public List<Graph.Edge<T, U>> getOutboundEdges(T value) {
        HashNode<T, U> node = this.nodes.get(value);
        if (node == null) {
            return null;
        }
        return node.outbound.stream().map(HashEdge::toEdge).collect(Collectors.toList());
    }

    @Override
    public List<Graph.Path<T>> getPaths(T origin, T destination) {
        ArrayList paths = new ArrayList();
        LinkedList current = new LinkedList();
        this.traverse(origin, false, null, (originValue, destinationValue, edgeValue, depth, isLast) -> {
            if (depth == 1) {
                current.clear();
                current.add(origin);
            }
            current.add(destinationValue);
            boolean finished = destinationValue.equals(destination);
            if (finished) {
                paths.add(new Graph.BasePath(current));
            }
            return !finished;
        });
        return paths;
    }

    public int hashCode() {
        return this.nodes.hashCode();
    }

    @Override
    public void prune(T ... excludes) {
        HashSet<T> excludeValues = new HashSet<T>(Arrays.asList(excludes));
        this.nodes.values().forEach(node -> {
            if (!excludeValues.contains(node.value) && node.inbound.isEmpty()) {
                this.removeNode(node.value);
            }
        });
    }

    @Override
    public void removeEdge(T origin, T destination, U value) {
        HashNode<T, U> originNode = this.nodes.get(origin);
        HashNode<T, U> destinationNode = this.nodes.get(destination);
        HashEdge<T, U> edge = new HashEdge<T, U>(originNode, destinationNode, value);
        originNode.removeEdge(edge);
        destinationNode.removeEdge(edge);
    }

    @Override
    public void removeNode(T value) throws CyclicException {
        HashNode<T, U> node = this.nodes.get(value);
        if (node == null) {
            return;
        }
        ArrayList outboundEdges = new ArrayList(node.outbound);
        this.clearEdges(node);
        outboundEdges.stream().filter(edge -> edge.destination.inbound.isEmpty()).forEach(edge -> this.removeNode(edge.destination.value));
        this.nodes.remove(value);
    }

    @Override
    public int size() {
        return this.nodes.size();
    }

    @Override
    public void traverse(T rootValue, boolean visitNodesOnce, Graph.EdgeFilter<T, U> edgeFilter, Graph.GraphConsumer<T, U> consumer) throws CyclicException {
        HashNode<T, U> rootNode = this.nodes.get(rootValue);
        if (rootNode == null) {
            throw new IllegalArgumentException("Invalid rootValue [" + rootValue + "] to start the traversal from.");
        }
        if (edgeFilter == null) {
            edgeFilter = new Graph.EdgeFilter.IdentityEdgeFilter();
        }
        HashSet cycleCheck = new HashSet();
        HashSet visited = new HashSet();
        this.traverse(rootNode, null, visitNodesOnce, cycleCheck, visited, edgeFilter, consumer, 1);
    }

    @Override
    public void traverseUp(T rootValue, Graph.GraphVisitor<T, U> visitor) throws CyclicException {
        HashNode<T, U> rootNode = this.nodes.get(rootValue);
        if (rootNode == null) {
            throw new IllegalArgumentException("Invalid rootValue [" + rootValue + "] to start the traversal from.");
        }
        HashSet visited = new HashSet();
        this.traverseUp(rootNode, visited, visitor, 1);
    }

    @Override
    public Set<T> values() {
        return new HashSet<T>(this.nodes.keySet());
    }

    protected HashNode<T, U> addNode(T value) {
        HashNode<T, U> node = this.nodes.get(value);
        if (node == null) {
            node = new HashNode(value);
            this.nodes.put(value, node);
        }
        return node;
    }

    protected void clearEdges(HashNode<T, U> node) {
        new ArrayList(node.outbound).forEach(edge -> this.removeEdge(edge.origin.value, edge.destination.value, edge.value));
        node.outbound.clear();
        new ArrayList(node.inbound).forEach(edge -> this.removeEdge(edge.origin.value, edge.destination.value, edge.value));
        node.inbound.clear();
    }

    protected T find(HashNode<T, U> root, Set<T> visited, Predicate<T> predicate) {
        if (predicate.test(root.value)) {
            return root.value;
        }
        for (HashEdge edge : root.outbound) {
            if (visited.contains(edge.destination.value)) {
                throw new CyclicException("Encountered the graph node [" + edge.destination.value + "] twice. Your graph has a cycle");
            }
            visited.add(root.value);
            Object result = this.find(edge.destination, visited, predicate);
            if (result != null) {
                return result;
            }
            visited.remove(root.value);
        }
        return null;
    }

    protected HashNode<T, U> getNode(T value) {
        return this.nodes.get(value);
    }

    protected void traverse(HashNode<T, U> root, HashEdge<T, U> traversedEdge, boolean visitNodesOnce, Set<T> cycleCheck, Set<T> visited, Graph.EdgeFilter<T, U> edgeFilter, Graph.GraphConsumer<T, U> consumer, int depth) {
        List edges = root.outbound;
        if (traversedEdge != null) {
            edges = root.outbound.stream().filter(edge -> edgeFilter.filter(edge.toEdge(), traversedEdge.toEdge())).collect(Collectors.toList());
        }
        for (int i = 0; i < edges.size(); ++i) {
            HashEdge edge2 = edges.get(i);
            if (cycleCheck.contains(edge2.destination.value)) {
                throw new CyclicException("Encountered the graph node [" + edge2.destination.value + "] twice. Your graph has a cycle");
            }
            if (visitNodesOnce && visited.contains(edge2.destination.value)) continue;
            cycleCheck.add(root.value);
            boolean cont = consumer.consume(root.value, edge2.destination.value, edge2.value, depth, i + 1 == edges.size());
            visited.add(edge2.destination.value);
            if (cont) {
                this.traverse(edge2.destination, edge2, visitNodesOnce, cycleCheck, visited, edgeFilter, consumer, depth + 1);
            }
            cycleCheck.remove(root.value);
        }
    }

    protected void traverseUp(HashNode<T, U> root, Set<T> visited, Graph.GraphVisitor<T, U> consumer, int depth) {
        root.outbound.forEach(edge -> {
            if (visited.contains(edge.destination.value)) {
                throw new CyclicException("Encountered the graph node [" + edge.destination.value + "] twice. Your graph has a cycle");
            }
            visited.add(root.value);
            this.traverseUp(edge.destination, visited, consumer, depth + 1);
            consumer.visit(root.value, edge.destination.value, edge.value, depth);
            visited.remove(root.value);
        });
    }

    protected static class HashNode<T, U> {
        public final List<HashEdge<T, U>> inbound = new ArrayList<HashEdge<T, U>>();
        public final List<HashEdge<T, U>> outbound = new ArrayList<HashEdge<T, U>>();
        public T value;

        public HashNode(T value) {
            this.value = value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            HashNode that = (HashNode)o;
            if (!this.value.equals(that.value)) {
                return false;
            }
            if (this.inbound.size() != that.inbound.size()) {
                return false;
            }
            if (this.outbound.size() != that.outbound.size()) {
                return false;
            }
            for (HashEdge<T, U> myEdge : this.outbound) {
                boolean matches = that.outbound.stream().anyMatch(theirEdge -> myEdge.value.equals(theirEdge.value) && myEdge.destination.value.equals(theirEdge.destination.value));
                if (matches) continue;
                return false;
            }
            return true;
        }

        public int hashCode() {
            int result = this.inbound.hashCode();
            result = 31 * result + this.outbound.hashCode();
            result = 31 * result + this.value.hashCode();
            return result;
        }

        public void removeEdge(HashEdge<T, U> edge) {
            this.outbound.remove(edge);
            this.inbound.remove(edge);
        }

        public String toString() {
            return this.value.toString();
        }

        void addInboundEdge(HashNode<T, U> origin, U edgeValue) {
            HashEdge<T, U> edge = new HashEdge<T, U>(origin, this, edgeValue);
            if (!this.inbound.contains(edge)) {
                this.inbound.add(edge);
            }
        }

        void addOutboundEdge(HashNode<T, U> destination, U edgeValue) {
            HashEdge<T, U> edge = new HashEdge<T, U>(this, destination, edgeValue);
            if (!this.outbound.contains(edge)) {
                this.outbound.add(edge);
            }
        }
    }

    protected static class HashEdge<T, U> {
        public final HashNode<T, U> destination;
        public final HashNode<T, U> origin;
        public final U value;

        public HashEdge(HashNode<T, U> origin, HashNode<T, U> destination, U value) {
            this.origin = origin;
            this.destination = destination;
            this.value = value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            HashEdge hashEdge = (HashEdge)o;
            return this.destination.value.equals(hashEdge.destination.value) && this.origin.value.equals(hashEdge.origin.value) && this.value.equals(hashEdge.value);
        }

        public int hashCode() {
            int result = this.destination.value.hashCode();
            result = 31 * result + this.origin.value.hashCode();
            result = 31 * result + this.value.hashCode();
            return result;
        }

        public Graph.Edge<T, U> toEdge() {
            return new Graph.Edge.BaseEdge(this.origin.value, this.destination.value, this.value);
        }
    }
}

