/*
 * Decompiled with CFR 0.152.
 */
package org.savantbuild.util;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import org.savantbuild.util.CyclicException;

public interface Graph<T, U> {
    public void addEdge(T var1, T var2, U var3);

    public boolean contains(T var1);

    public T find(T var1, Predicate<T> var2) throws CyclicException;

    public List<Edge<T, U>> getInboundEdges(T var1);

    public List<Edge<T, U>> getOutboundEdges(T var1);

    public List<Path<T>> getPaths(T var1, T var2);

    public void prune(T ... var1);

    public void removeEdge(T var1, T var2, U var3);

    public void removeNode(T var1) throws CyclicException;

    public int size();

    public void traverse(T var1, boolean var2, EdgeFilter<T, U> var3, GraphConsumer<T, U> var4) throws CyclicException;

    public void traverseUp(T var1, GraphVisitor<T, U> var2) throws CyclicException;

    public Set<T> values();

    public static class BasePath<T>
    implements Path<T> {
        private final List<T> path;

        public BasePath(List<T> path) {
            this.path = Collections.unmodifiableList(new LinkedList<T>(path));
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            BasePath basePath = (BasePath)o;
            return this.path.equals(basePath.path);
        }

        @Override
        public List<T> get() {
            return this.path;
        }

        public int hashCode() {
            return this.path.hashCode();
        }
    }

    public static interface Path<T> {
        public List<T> get();
    }

    public static interface GraphVisitor<T, U> {
        public void visit(T var1, T var2, U var3, int var4);
    }

    public static interface GraphConsumer<T, U> {
        public boolean consume(T var1, T var2, U var3, int var4, boolean var5);
    }

    public static interface EdgeFilter<T, U> {
        public boolean filter(Edge<T, U> var1, Edge<T, U> var2);

        public static class IdentityEdgeFilter<T, U>
        implements EdgeFilter<T, U> {
            @Override
            public boolean filter(Edge<T, U> edge, Edge<T, U> entryPoint) {
                return true;
            }
        }
    }

    public static interface Edge<T, U> {
        public T getDestination();

        public T getOrigin();

        public U getValue();

        public static class BaseEdge<T, U>
        implements Edge<T, U> {
            public final T destination;
            public final T origin;
            public final U value;

            public BaseEdge(T origin, T destination, U value) {
                this.origin = origin;
                this.destination = destination;
                this.value = value;
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                BaseEdge baseEdge = (BaseEdge)o;
                return this.destination.equals(baseEdge.destination) && this.origin.equals(baseEdge.origin) && this.value.equals(baseEdge.value);
            }

            @Override
            public T getDestination() {
                return this.destination;
            }

            @Override
            public T getOrigin() {
                return this.origin;
            }

            @Override
            public U getValue() {
                return this.value;
            }

            public int hashCode() {
                int result = this.destination.hashCode();
                result = 31 * result + this.origin.hashCode();
                result = 31 * result + this.value.hashCode();
                return result;
            }

            public String toString() {
                return this.origin + "-(" + this.value + ")->" + this.destination;
            }
        }
    }
}

