/*
 * Decompiled with CFR 0.152.
 */
package org.savantbuild.security;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import org.savantbuild.lang.StringTools;
import org.savantbuild.security.MD5Exception;

public final class MD5 {
    public final byte[] bytes;
    public final String fileName;
    public final String sum;

    public MD5(String sum, byte[] bytes, String fileName) {
        this.sum = sum;
        this.bytes = bytes;
        this.fileName = fileName;
    }

    public static MD5 forBytes(byte[] bytes, String fileName) throws IOException {
        MessageDigest digest = null;
        try {
            digest = MessageDigest.getInstance("MD5");
            digest.reset();
        }
        catch (NoSuchAlgorithmException e) {
            System.err.println("Unable to locate MD5 algorithm");
            System.exit(1);
        }
        ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
        DigestInputStream dis = new DigestInputStream(bais, digest);
        byte[] ba = new byte[1024];
        while (dis.read(ba, 0, 1024) != -1) {
        }
        dis.close();
        byte[] md5 = digest.digest();
        return new MD5(StringTools.toHex(md5), md5, fileName);
    }

    public static MD5 forPath(Path path) throws IOException {
        if (!Files.isRegularFile(path, new LinkOption[0])) {
            throw new IllegalArgumentException("File to MD5 doesn't exist [" + path.toAbsolutePath() + "]");
        }
        return MD5.forBytes(Files.readAllBytes(path), path.getFileName().toString());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static MD5 load(Path path) throws IOException {
        String sum;
        if (path == null || !Files.isRegularFile(path, new LinkOption[0])) {
            return null;
        }
        String str = new String(Files.readAllBytes(path), "UTF-8").trim();
        if (str.length() < 32) {
            throw new MD5Exception("Invalid MD5 [" + str + "] in file [" + path + "]");
        }
        String name = null;
        if (str.length() == 32) {
            sum = str;
            return new MD5(sum, StringTools.fromHex(sum), name);
        } else {
            if (str.length() <= 33) throw new MD5Exception("Invalid MD5 [" + str + "] in file [" + path + "]. It has a length of [" + str.length() + "] and it should be 32");
            int index = str.indexOf(" ");
            if (index != 32) throw new MD5Exception("Invalid MD5 [" + str + "] in file [" + path + "]");
            sum = str.substring(0, 32);
            while (str.charAt(index) == ' ') {
                ++index;
            }
            if (index == str.length()) {
                throw new MD5Exception("Invalid MD5 [" + str + "] in file [" + path + "]");
            }
            name = str.substring(index);
        }
        return new MD5(sum, StringTools.fromHex(sum), name);
    }

    public static void writeMD5(MD5 md5, Path path) throws IOException {
        String sum = md5.sum;
        if (!sum.endsWith("\n")) {
            sum = sum + "\n";
        }
        Files.write(path, sum.getBytes("UTF-8"), new OpenOption[0]);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MD5 md5 = (MD5)o;
        return Arrays.equals(this.bytes, md5.bytes);
    }

    public int hashCode() {
        return Arrays.hashCode(this.bytes);
    }
}

