/*
 * Decompiled with CFR 0.152.
 */
package org.savantbuild.output;

import java.io.PrintStream;
import org.savantbuild.output.Ansi256Colors;
import org.savantbuild.output.Output;

public class SystemOutOutput
implements Output {
    private final boolean colorize;
    private final PrintStream out;
    private boolean debugEnabled;

    public SystemOutOutput(boolean colorize) {
        this.out = System.out;
        this.colorize = colorize;
    }

    SystemOutOutput(PrintStream out, boolean colorize) {
        this.out = out;
        this.colorize = colorize;
    }

    @Override
    public Output debug(String message, Object ... values) {
        if (this.debugEnabled) {
            this.print(message, values);
        }
        return this;
    }

    @Override
    public Output debugln(String message, Object ... values) {
        if (this.debugEnabled) {
            this.println(message, values);
        }
        return this;
    }

    @Override
    public Output debug(Throwable t) {
        if (this.debugEnabled) {
            t.printStackTrace(this.out);
        }
        return this;
    }

    @Override
    public Output disableDebug() {
        this.debugEnabled = false;
        return this;
    }

    @Override
    public Output enableDebug() {
        this.debugEnabled = true;
        return this;
    }

    @Override
    public Output error(String message, Object ... values) {
        if (this.colorize) {
            Ansi256Colors.setColor(this.out, (short)124);
        }
        this.print(message, values);
        if (this.colorize) {
            Ansi256Colors.clear(this.out);
        }
        return this;
    }

    @Override
    public Output errorln(String message, Object ... values) {
        if (this.colorize) {
            Ansi256Colors.setColor(this.out, (short)124);
        }
        this.println(message, values);
        if (this.colorize) {
            Ansi256Colors.clear(this.out);
        }
        return this;
    }

    @Override
    public Output info(String message, Object ... values) {
        this.print(message, values);
        return this;
    }

    @Override
    public Output infoln(String message, Object ... values) {
        this.println(message, values);
        return this;
    }

    @Override
    public Output warning(String message, Object ... values) {
        if (this.colorize) {
            Ansi256Colors.setColor(this.out, (short)214);
        }
        this.print(message, values);
        if (this.colorize) {
            Ansi256Colors.clear(this.out);
        }
        return this;
    }

    @Override
    public Output warningln(String message, Object ... values) {
        if (this.colorize) {
            Ansi256Colors.setColor(this.out, (short)214);
        }
        this.println(message, values);
        if (this.colorize) {
            Ansi256Colors.clear(this.out);
        }
        return this;
    }

    private void print(String message, Object[] values) {
        if (values.length == 0) {
            this.out.print(message);
        } else {
            this.out.printf(message, values);
        }
    }

    private void println(String message, Object[] values) {
        if (values.length == 0) {
            this.out.println(message);
        } else {
            this.out.printf(message + "\n", values);
        }
    }
}

