/*
 * Decompiled with CFR 0.152.
 */
package org.savantbuild.lang;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class Classpath {
    public final List<Path> paths = new ArrayList<Path>();

    public Classpath(String ... paths) {
        for (String path : paths) {
            this.paths.add(Paths.get(path, new String[0]));
        }
    }

    public Classpath path(String path) {
        this.paths.add(Paths.get(path, new String[0]));
        return this;
    }

    public Classpath path(Path path) {
        this.paths.add(path);
        return this;
    }

    public Classpath path(File file) {
        this.paths.add(file.toPath());
        return this;
    }

    public Classpath paths(Path ... paths) {
        Collections.addAll(this.paths, paths);
        return this;
    }

    public String toString() {
        if (this.paths.isEmpty()) {
            return "";
        }
        return String.join((CharSequence)File.pathSeparator, this.paths.stream().map(Path::toString).collect(Collectors.toList()));
    }

    public String toString(String prefix) {
        if (this.paths.isEmpty()) {
            return "";
        }
        return prefix + this.toString();
    }

    public URLClassLoader toURLClassLoader() throws IllegalStateException {
        ArrayList<URL> urls = new ArrayList<URL>();
        for (Path path : this.paths) {
            try {
                urls.add(path.toUri().toURL());
            }
            catch (MalformedURLException e) {
                throw new IllegalStateException(e);
            }
        }
        return new URLClassLoader(urls.toArray(new URL[urls.size()]));
    }
}

