/*
 * Decompiled with CFR 0.152.
 */
package org.savantbuild.dep.xml;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.savantbuild.dep.domain.Artifact;
import org.savantbuild.dep.domain.ArtifactID;
import org.savantbuild.dep.domain.ArtifactMetaData;
import org.savantbuild.dep.domain.Dependencies;
import org.savantbuild.dep.domain.DependencyGroup;
import org.savantbuild.dep.domain.License;
import org.savantbuild.domain.Version;
import org.savantbuild.domain.VersionException;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ArtifactTools {
    public static Path generateXML(ArtifactMetaData artifactMetaData) throws IOException {
        File tmp = File.createTempFile("savant", "amd");
        tmp.deleteOnExit();
        try (PrintWriter pw = new PrintWriter(new FileWriter(tmp));){
            pw.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
            pw.printf("<artifact-meta-data>\n", new Object[0]);
            artifactMetaData.licenses.forEach(license -> {
                if (license.text != null) {
                    pw.printf("  <license type=\"%s\"><![CDATA[%s]]></license>\n", license.identifier.replace("\"", "&quot;"), license.text);
                } else {
                    pw.printf("  <license type=\"%s\"/>\n", license.identifier.replace("\"", "&quot;"));
                }
            });
            Dependencies dependencies = artifactMetaData.dependencies;
            if (dependencies != null) {
                pw.println("  <dependencies>");
                dependencies.groups.forEach((type, group) -> {
                    if (!group.export) {
                        return;
                    }
                    pw.printf("    <dependency-group name=\"%s\">\n", group.name.replace("\"", "&quot;"));
                    for (Artifact dependency : group.dependencies) {
                        pw.printf("      <dependency group=\"%s\" project=\"%s\" name=\"%s\" version=\"%s\" type=\"%s\"/>\n", dependency.id.group.replace("\"", "&quot;"), dependency.id.project.replace("\"", "&quot;"), dependency.id.name.replace("\"", "&quot;"), dependency.version.toString().replace("\"", "&quot;"), dependency.id.type.replace("\"", "&quot;"));
                    }
                    pw.println("    </dependency-group>");
                });
                pw.println("  </dependencies>");
            }
            pw.println("</artifact-meta-data>");
        }
        return tmp.toPath();
    }

    public static ArtifactMetaData parseArtifactMetaData(Path file) throws SAXException, VersionException, ParserConfigurationException, IOException {
        SAXParser parser = SAXParserFactory.newInstance().newSAXParser();
        ArtifactMetaDataHandler handler = new ArtifactMetaDataHandler();
        parser.parse(file.toFile(), (DefaultHandler)handler);
        return new ArtifactMetaData(handler.dependencies, handler.licenses);
    }

    public static class ArtifactMetaDataHandler
    extends DefaultHandler {
        public final List<License> licenses = new ArrayList<License>();
        public Dependencies dependencies;
        public DependencyGroup group;
        public StringBuilder licenseText;
        private String licenseId;

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            if (this.licenseText != null) {
                this.licenseText.append(ch, start, length);
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (qName.equals("license")) {
                String text = this.licenseText.toString().trim();
                if (text.trim().isEmpty()) {
                    text = null;
                }
                try {
                    License license = License.parse(this.licenseId, text);
                    this.licenses.add(license);
                }
                catch (IllegalArgumentException e) {
                    throw new SAXException("Invalid AMD file. The license [" + this.licenseId + "] is not an allowed license type. Allowable values are " + License.Licenses.keySet() + " plus the custom license types of [Commercial, Other, OtherDistributableOpenSource, OtherNonDistributableOpenSource]", e);
                }
                this.licenseId = null;
                this.licenseText = null;
            }
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            switch (qName) {
                case "dependencies": {
                    this.dependencies = new Dependencies(new DependencyGroup[0]);
                    break;
                }
                case "dependency-group": {
                    String name = attributes.getValue("name");
                    if (name == null) {
                        throw new SAXException("Invalid AMD file. The dependency-group elements must specify a [name] attribute");
                    }
                    this.group = new DependencyGroup(name, true, new Artifact[0]);
                    this.dependencies.groups.put(name, this.group);
                    break;
                }
                case "dependency": {
                    String dependencyGroup = attributes.getValue("group");
                    if (dependencyGroup == null) {
                        throw new SAXException("Invalid AMD file. The dependency elements must specify a [group] attribute");
                    }
                    String dependencyProject = attributes.getValue("project");
                    if (dependencyProject == null) {
                        throw new SAXException("Invalid AMD file. The dependency elements must specify a [project] attribute");
                    }
                    String dependencyName = attributes.getValue("name");
                    if (dependencyName == null) {
                        throw new SAXException("Invalid AMD file. The dependency elements must specify a [name] attribute");
                    }
                    String dependencyType = attributes.getValue("type");
                    if (dependencyType == null) {
                        throw new SAXException("Invalid AMD file. The dependency elements must specify a [type] attribute");
                    }
                    String dependencyVersion = attributes.getValue("version");
                    if (dependencyVersion == null) {
                        throw new SAXException("Invalid AMD file. The dependency elements must specify a [version] attribute");
                    }
                    if (this.group == null) {
                        throw new SAXException("Invalid AMD file. A dependency doesn't appear to be inside a dependency-group element");
                    }
                    Artifact dependency = new Artifact(new ArtifactID(dependencyGroup, dependencyProject, dependencyName, dependencyType), new Version(dependencyVersion), false);
                    this.group.dependencies.add(dependency);
                    break;
                }
                case "license": {
                    this.licenseId = attributes.getValue("type");
                    if (this.licenseId == null) {
                        throw new SAXException("Invalid AMD file. The license elements must contain a [type] attribute");
                    }
                    this.licenseText = new StringBuilder();
                    break;
                }
                case "artifact-meta-data": {
                    if (attributes.getValue("license") == null) break;
                    throw new IllegalArgumentException("Invalid AMD file. It contains the old license definition on the <artifact-meta-data> element");
                }
                default: {
                    throw new SAXException("Invalid element encountered in AMD file [" + qName + "].");
                }
            }
        }
    }
}

