/*
 * Decompiled with CFR 0.152.
 */
package org.savantbuild.dep.workflow.process;

import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import org.savantbuild.dep.PathTools;
import org.savantbuild.dep.domain.Artifact;
import org.savantbuild.dep.workflow.PublishWorkflow;
import org.savantbuild.dep.workflow.process.NegativeCacheException;
import org.savantbuild.dep.workflow.process.Process;
import org.savantbuild.dep.workflow.process.ProcessFailureException;
import org.savantbuild.output.Output;

public class CacheProcess
implements Process {
    public final String dir;
    public final Output output;

    public CacheProcess(Output output, String dir) {
        this.output = output;
        this.dir = dir == null ? System.getProperty("user.home") + "/.savant/cache" : dir;
    }

    @Override
    public void deleteIntegrationBuilds(Artifact artifact) throws ProcessFailureException {
        String path = String.join((CharSequence)"/", this.dir, artifact.id.group.replace('.', '/'), artifact.id.project, artifact.version + "-{integration}");
        Path dir = Paths.get(path, new String[0]);
        if (!Files.isDirectory(dir, new LinkOption[0])) {
            return;
        }
        try {
            PathTools.prune(dir);
        }
        catch (IOException e) {
            throw new ProcessFailureException(artifact, "Unable to delete integration builds from the local cache at [" + dir.toAbsolutePath() + "]", e);
        }
    }

    @Override
    public Path fetch(Artifact artifact, String item, PublishWorkflow publishWorkflow) throws NegativeCacheException {
        String path = String.join((CharSequence)"/", this.dir, artifact.id.group.replace('.', '/'), artifact.id.project, artifact.version.toString(), item);
        Path file = Paths.get(path, new String[0]);
        if (!Files.isRegularFile(file, new LinkOption[0])) {
            file = Paths.get(path + ".neg", new String[0]);
            if (Files.isRegularFile(file, new LinkOption[0])) {
                throw new NegativeCacheException(artifact);
            }
            file = null;
        }
        return file;
    }

    @Override
    public Path publish(Artifact artifact, String item, Path artifactFile) throws ProcessFailureException {
        String cachePath = String.join((CharSequence)"/", this.dir, artifact.id.group.replace('.', '/'), artifact.id.project, artifact.version.toString(), item);
        Path cacheFile = Paths.get(cachePath, new String[0]);
        if (Files.isDirectory(cacheFile, new LinkOption[0])) {
            throw new ProcessFailureException(artifact, "Your local artifact cache location is a directory [" + cacheFile.toAbsolutePath() + "]");
        }
        if (Files.isRegularFile(cacheFile, new LinkOption[0])) {
            try {
                Files.delete(cacheFile);
            }
            catch (IOException e) {
                throw new ProcessFailureException(artifact, "Unable to delete old file in the local cache to replace [" + cacheFile.toAbsolutePath() + "]", e);
            }
        }
        if (!Files.exists(cacheFile, new LinkOption[0])) {
            try {
                Files.createDirectories(cacheFile.getParent(), new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new ProcessFailureException(artifact, "Unable to create cache directory [" + cacheFile.getParent().toAbsolutePath() + "]");
            }
        }
        try {
            Files.copy(artifactFile, cacheFile, new CopyOption[0]);
        }
        catch (IOException e) {
            if (Files.exists(cacheFile, new LinkOption[0])) {
                try {
                    Files.delete(cacheFile);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            throw new ProcessFailureException(artifact, (Throwable)e);
        }
        this.output.debugln("Cached at [%s]", new Object[]{cacheFile});
        return cacheFile;
    }

    public String toString() {
        return "Cache(" + this.dir + ")";
    }
}

