/*
 * Decompiled with CFR 0.152.
 */
package org.savantbuild.dep.workflow;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.savantbuild.dep.domain.Artifact;
import org.savantbuild.dep.workflow.process.Process;
import org.savantbuild.dep.workflow.process.ProcessFailureException;

public class PublishWorkflow {
    public final List<Process> processes = new ArrayList<Process>();

    public PublishWorkflow(Process ... processes) {
        Collections.addAll(this.processes, processes);
    }

    public void deleteIntegrationBuilds(Artifact artifact) {
        for (Process process : this.processes) {
            process.deleteIntegrationBuilds(artifact);
        }
    }

    public List<Process> getProcesses() {
        return this.processes;
    }

    public Path publish(Artifact artifact, String item, Path file) throws ProcessFailureException {
        Path result = null;
        for (Process process : this.processes) {
            Path temp = process.publish(artifact, item, file);
            if (result != null) continue;
            result = temp;
        }
        return result;
    }

    public void publishNegative(Artifact artifact, String item) {
        Path itemFile;
        try {
            File tempFile = File.createTempFile("savant-item", "neg");
            tempFile.deleteOnExit();
            itemFile = tempFile.toPath();
        }
        catch (IOException e) {
            return;
        }
        for (Process process : this.processes) {
            try {
                process.publish(artifact, item + ".neg", itemFile);
            }
            catch (ProcessFailureException processFailureException) {}
        }
    }
}

