/*
 * Decompiled with CFR 0.152.
 */
package org.savantbuild.dep.graph;

import java.nio.file.Path;
import java.util.Formatter;
import org.savantbuild.dep.domain.ArtifactID;
import org.savantbuild.dep.domain.ResolvedArtifact;
import org.savantbuild.lang.Classpath;
import org.savantbuild.util.HashGraph;

public class ResolvedArtifactGraph
extends HashGraph<ResolvedArtifact, String> {
    public final ResolvedArtifact root;

    public ResolvedArtifactGraph(ResolvedArtifact root) {
        this.root = root;
    }

    public Path getPath(ArtifactID id) {
        ResolvedArtifact match = (ResolvedArtifact)this.find(this.root, artifact -> artifact.id.equals(id));
        if (match != null) {
            return match.file;
        }
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ResolvedArtifactGraph that = (ResolvedArtifactGraph)((Object)o);
        return this.root.equals(that.root);
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.root.hashCode();
        return result;
    }

    public Classpath toClasspath() {
        if (this.size() == 0) {
            return new Classpath(new String[0]);
        }
        Classpath classpath = new Classpath(new String[0]);
        this.traverse(this.root, true, null, (origin, destination, value, depth, isLast) -> {
            classpath.path(destination.file);
            return true;
        });
        return classpath;
    }

    public String toDOT() {
        StringBuilder build = new StringBuilder();
        build.append("digraph ResolvedArtifactGraph {\n");
        Formatter formatter = new Formatter(build);
        this.traverse(this.root, false, null, (origin, destination, edge, depth, isLast) -> {
            formatter.format("  \"%s\" -> \"%s\" [label=\"%s\"];\n", origin, destination, edge);
            return true;
        });
        build.append("}\n");
        return build.toString();
    }

    public String toString() {
        return this.toDOT();
    }
}

