/*
 * Decompiled with CFR 0.152.
 */
package org.savantbuild.dep.graph;

import java.util.Formatter;
import org.savantbuild.dep.domain.ArtifactID;
import org.savantbuild.dep.domain.ReifiedArtifact;
import org.savantbuild.dep.graph.DependencyEdgeValue;
import org.savantbuild.util.Graph;
import org.savantbuild.util.HashGraph;

public class DependencyGraph
extends HashGraph<Dependency, DependencyEdgeValue> {
    public final ReifiedArtifact root;

    public DependencyGraph(ReifiedArtifact root) {
        this.root = root;
    }

    public void skipCompatibilityCheck(ArtifactID id) {
        HashGraph.HashNode node = this.getNode(new Dependency(id));
        ((Dependency)node.value).skipCompatibilityCheck = true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DependencyGraph that = (DependencyGraph)((Object)o);
        return this.root.equals(that.root);
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.root.hashCode();
        return result;
    }

    public void versionCorrectTraversal(Graph.GraphConsumer<Dependency, DependencyEdgeValue> consumer) {
        super.traverse((Object)new Dependency(this.root.id), false, (edge, traversedEdge) -> ((DependencyEdgeValue)edge.getValue()).dependentVersion.equals((Object)((DependencyEdgeValue)traversedEdge.getValue()).dependencyVersion), consumer);
    }

    public String toDOT() {
        StringBuilder build = new StringBuilder();
        build.append("digraph Dependencies {\n");
        Formatter formatter = new Formatter(build);
        this.traverse(new Dependency(this.root.id), false, null, (origin, destination, edge, depth, isLast) -> {
            formatter.format("  \"%s\" -> \"%s\" [label=\"%s\", headlabel=\"%s\", taillabel=\"%s\"];\n", origin, destination, edge.type, edge.dependentVersion, edge.dependencyVersion);
            return true;
        });
        build.append("}\n");
        return build.toString();
    }

    public String toString() {
        return this.toDOT();
    }

    public static class Dependency {
        public final ArtifactID id;
        public boolean skipCompatibilityCheck;

        public Dependency(ArtifactID id) {
            this.id = id;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Dependency that = (Dependency)o;
            return this.id.equals(that.id);
        }

        public int hashCode() {
            return this.id.hashCode();
        }

        public String toString() {
            return "Dependency{id=" + this.id + ", skipCompatibilityCheck=" + this.skipCompatibilityCheck + '}';
        }
    }
}

