/*
 * Decompiled with CFR 0.152.
 */
package org.savantbuild.dep.graph;

import java.util.Formatter;
import org.savantbuild.dep.domain.ReifiedArtifact;
import org.savantbuild.util.HashGraph;

public class ArtifactGraph
extends HashGraph<ReifiedArtifact, String> {
    public final ReifiedArtifact root;

    public ArtifactGraph(ReifiedArtifact root) {
        this.root = root;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ArtifactGraph that = (ArtifactGraph)((Object)o);
        return this.root.equals(that.root);
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.root.hashCode();
        return result;
    }

    public String toDOT() {
        StringBuilder build = new StringBuilder();
        build.append("digraph ArtifactGraph {\n");
        Formatter formatter = new Formatter(build);
        this.traverse(this.root, false, null, (origin, destination, edge, depth, isLast) -> {
            formatter.format("  \"%s\" -> \"%s\" [label=\"%s\"];\n", origin, destination, edge);
            return true;
        });
        build.append("}\n");
        return build.toString();
    }

    public String toString() {
        return this.toDOT();
    }
}

