/*
 * Decompiled with CFR 0.152.
 */
package org.savantbuild.dep.domain;

import java.nio.file.Path;
import java.util.Objects;
import org.savantbuild.dep.domain.Artifact;
import org.savantbuild.dep.domain.ArtifactMetaData;

public class Publication {
    public final Artifact artifact;
    public final Path file;
    public final ArtifactMetaData metaData;
    public final Path sourceFile;

    public Publication(Artifact artifact, ArtifactMetaData metaData, Path file, Path sourceFile) {
        Objects.requireNonNull(artifact, "Publications must have an Artifact");
        Objects.requireNonNull(metaData, "Publications must have ArtifactMetaData");
        Objects.requireNonNull(file, "Publications must have a file");
        this.sourceFile = sourceFile;
        this.file = file;
        this.metaData = metaData;
        this.artifact = artifact;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Publication that = (Publication)o;
        return this.artifact.equals(that.artifact) && this.file.equals(that.file) && this.metaData.equals(that.metaData) && (this.sourceFile != null ? this.sourceFile.equals(that.sourceFile) : that.sourceFile == null);
    }

    public int hashCode() {
        int result = this.artifact.hashCode();
        result = 31 * result + this.metaData.hashCode();
        result = 31 * result + this.file.hashCode();
        result = 31 * result + (this.sourceFile != null ? this.sourceFile.hashCode() : 0);
        return result;
    }

    public String toString() {
        return this.artifact + "{licenses:" + this.metaData.licenses + "}{file:" + this.file + "}{source:" + (this.sourceFile != null ? this.sourceFile.toString() : "none") + "}";
    }
}

