/*
 * Decompiled with CFR 0.152.
 */
package org.savantbuild.dep.domain;

import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.savantbuild.dep.domain.Artifact;
import org.savantbuild.dep.domain.DependencyGroup;

public class Dependencies {
    public final Map<String, DependencyGroup> groups = new LinkedHashMap<String, DependencyGroup>();

    public Dependencies(DependencyGroup ... groups) {
        for (DependencyGroup group : groups) {
            this.groups.put(group.name, group);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Dependencies that = (Dependencies)o;
        return this.groups.equals(that.groups);
    }

    public Set<Artifact> getAllArtifacts() {
        HashSet<Artifact> set = new HashSet<Artifact>();
        this.groups.values().forEach(group -> set.addAll(group.dependencies));
        return set;
    }

    public int hashCode() {
        return this.groups.hashCode();
    }
}

