/*
 * Decompiled with CFR 0.152.
 */
package org.savantbuild.dep;

import java.util.ArrayList;
import java.util.Set;
import org.savantbuild.dep.graph.DependencyEdgeValue;
import org.savantbuild.dep.graph.DependencyGraph;
import org.savantbuild.output.Output;
import org.savantbuild.util.Graph;

public final class DependencyTreePrinter {
    public static void print(Output output, DependencyGraph graph, Set<DependencyGraph.Dependency> highlight, Set<DependencyGraph.Dependency> bold) {
        ArrayList lasts = new ArrayList();
        graph.versionCorrectTraversal((Graph.GraphConsumer<DependencyGraph.Dependency, DependencyEdgeValue>)((Graph.GraphConsumer)(origin, destination, edge, depth, isLast) -> {
            while (lasts.size() >= depth) {
                lasts.remove(lasts.size() - 1);
            }
            lasts.add(isLast);
            for (int i = 0; i < depth - 1; ++i) {
                if (!((Boolean)lasts.get(i)).booleanValue()) {
                    output.info("|", new Object[0]);
                }
                output.info("\t", new Object[0]);
            }
            if (isLast) {
                output.info("\\-", new Object[0]);
            } else {
                output.info("|-", new Object[0]);
            }
            if (bold != null && bold.contains(destination)) {
                output.error("[" + destination.id + ":" + edge.dependencyVersion + "]", new Object[0]);
            } else if (highlight != null && highlight.contains(destination)) {
                output.warning("[" + destination.id + ":" + edge.dependencyVersion + "]", new Object[0]);
            } else {
                output.info("[" + destination.id + ":" + edge.dependencyVersion + "]", new Object[0]);
            }
            output.infoln("", new Object[0]);
            return true;
        }));
    }
}

