/*
 * Decompiled with CFR 0.152.
 */
package org.savantbuild.dep;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.savantbuild.dep.DependencyListener;
import org.savantbuild.dep.DependencyService;
import org.savantbuild.dep.LicenseException;
import org.savantbuild.dep.PublishException;
import org.savantbuild.dep.domain.Artifact;
import org.savantbuild.dep.domain.ArtifactID;
import org.savantbuild.dep.domain.ArtifactMetaData;
import org.savantbuild.dep.domain.CompatibilityException;
import org.savantbuild.dep.domain.Dependencies;
import org.savantbuild.dep.domain.Publication;
import org.savantbuild.dep.domain.ReifiedArtifact;
import org.savantbuild.dep.domain.ResolvedArtifact;
import org.savantbuild.dep.graph.ArtifactGraph;
import org.savantbuild.dep.graph.DependencyEdgeValue;
import org.savantbuild.dep.graph.DependencyGraph;
import org.savantbuild.dep.graph.ResolvedArtifactGraph;
import org.savantbuild.dep.workflow.ArtifactMetaDataMissingException;
import org.savantbuild.dep.workflow.ArtifactMissingException;
import org.savantbuild.dep.workflow.PublishWorkflow;
import org.savantbuild.dep.workflow.Workflow;
import org.savantbuild.dep.workflow.process.ProcessFailureException;
import org.savantbuild.dep.xml.ArtifactTools;
import org.savantbuild.domain.Version;
import org.savantbuild.output.Output;
import org.savantbuild.security.MD5;
import org.savantbuild.security.MD5Exception;
import org.savantbuild.util.CyclicException;
import org.savantbuild.util.Graph;

public class DefaultDependencyService
implements DependencyService {
    private final Output output;

    public DefaultDependencyService(Output output) {
        this.output = output;
    }

    @Override
    public DependencyGraph buildGraph(ReifiedArtifact project, Dependencies dependencies, Workflow workflow) throws ArtifactMetaDataMissingException, ProcessFailureException, MD5Exception {
        this.output.debugln("Building DependencyGraph with a root of [%s]", new Object[]{project});
        DependencyGraph graph = new DependencyGraph(project);
        this.populateGraph(graph, project, dependencies, workflow, new HashSet<Artifact>());
        return graph;
    }

    @Override
    public void publish(Publication publication, PublishWorkflow workflow) throws PublishException {
        if (!Files.isReadable(publication.file)) {
            throw new PublishException("The publication file [" + publication.file + "] for the publication [" + publication.artifact + "] doesn't exist.");
        }
        if (publication.sourceFile != null && !Files.isReadable(publication.sourceFile)) {
            throw new PublishException("The publication source file [" + publication.sourceFile + "] for the publication [" + publication.artifact + "] doesn't exist.");
        }
        this.output.infoln("Publishing [%s]", new Object[]{publication});
        try {
            Path amdFile = ArtifactTools.generateXML(publication.metaData);
            this.publishItem(publication.artifact, publication.artifact.getArtifactMetaDataFile(), amdFile, workflow);
            this.publishItem(publication.artifact, publication.artifact.getArtifactFile(), publication.file, workflow);
            if (publication.sourceFile != null) {
                this.publishItem(publication.artifact, publication.artifact.getArtifactSourceFile(), publication.sourceFile, workflow);
            } else {
                workflow.publishNegative(publication.artifact, publication.artifact.getArtifactSourceFile());
            }
        }
        catch (IOException e) {
            throw new PublishException(publication, (Throwable)e);
        }
    }

    @Override
    public ArtifactGraph reduce(DependencyGraph graph) throws CompatibilityException, CyclicException {
        this.output.debugln("Reducing DependencyGraph with a root of [%s]", new Object[]{graph.root});
        ArtifactGraph artifactGraph = new ArtifactGraph(graph.root);
        HashMap<ArtifactID, ReifiedArtifact> artifacts = new HashMap<ArtifactID, ReifiedArtifact>();
        artifacts.put(graph.root.id, graph.root);
        HashSet seenAtLeastOnce = new HashSet();
        graph.traverse(new DependencyGraph.Dependency(graph.root.id), false, null, (origin, destination, edgeValue, depth, isLast) -> {
            boolean alreadyCheckedAllParents;
            List inboundEdges = graph.getInboundEdges(destination);
            boolean bl = alreadyCheckedAllParents = inboundEdges.size() > 0 && inboundEdges.stream().allMatch(edge -> artifacts.containsKey(((DependencyGraph.Dependency)edge.getOrigin()).id));
            if (alreadyCheckedAllParents) {
                this.output.debugln("Already checked all parents so we know the versions of them at this point. Working on node [%s]", new Object[]{destination});
                seenAtLeastOnce.remove(destination);
                return this.checkCompatibilityAndAddToGraph(graph, (Map<ArtifactID, ReifiedArtifact>)artifacts, (DependencyGraph.Dependency)destination, inboundEdges, artifactGraph);
            }
            this.output.debugln("Skipping dependency [%s] for now. Not all its parents have been checked", new Object[]{destination});
            seenAtLeastOnce.add(destination);
            return true;
        });
        seenAtLeastOnce.forEach(dependency -> {
            List inboundEdges = graph.getInboundEdges(dependency);
            this.checkCompatibilityAndAddToGraph(graph, (Map<ArtifactID, ReifiedArtifact>)artifacts, (DependencyGraph.Dependency)dependency, inboundEdges, artifactGraph);
        });
        return artifactGraph;
    }

    @Override
    public ResolvedArtifactGraph resolve(ArtifactGraph graph, Workflow workflow, DependencyService.TraversalRules configuration, DependencyListener ... listeners) throws CyclicException, ArtifactMissingException, ProcessFailureException, MD5Exception, LicenseException {
        this.output.debugln("Resolving ArtifactGraph with a root of [%s]", new Object[]{graph.root});
        ResolvedArtifact root = new ResolvedArtifact(graph.root.id, graph.root.version, graph.root.licenses, null, null);
        ResolvedArtifactGraph resolvedGraph = new ResolvedArtifactGraph(root);
        HashMap<ReifiedArtifact, ResolvedArtifact> map = new HashMap<ReifiedArtifact, ResolvedArtifact>();
        map.put(graph.root, root);
        AtomicReference rootTypeResolveConfiguration = new AtomicReference();
        graph.traverse(graph.root, false, null, (origin, destination, group, depth, isLast) -> {
            DependencyService.TraversalRules.GroupTraversalRule groupTraversalRule;
            if (origin.equals(graph.root)) {
                groupTraversalRule = configuration.rules.get(group);
                if (groupTraversalRule == null) {
                    return false;
                }
                rootTypeResolveConfiguration.set(groupTraversalRule);
            } else {
                groupTraversalRule = (DependencyService.TraversalRules.GroupTraversalRule)rootTypeResolveConfiguration.get();
                if (groupTraversalRule.transitiveGroups.size() > 0 && !groupTraversalRule.transitiveGroups.contains(group)) {
                    return false;
                }
            }
            if (groupTraversalRule.disallowedLicenses.stream().anyMatch(destination.licenses::contains)) {
                throw new LicenseException((ReifiedArtifact)destination);
            }
            Path file = workflow.fetchArtifact((Artifact)destination).toAbsolutePath();
            Path sourceFile = null;
            if (groupTraversalRule.fetchSource) {
                sourceFile = workflow.fetchSource((Artifact)destination);
            }
            ResolvedArtifact resolvedArtifact = new ResolvedArtifact(destination.id, destination.version, destination.licenses, file, sourceFile);
            resolvedGraph.addEdge(map.get(origin), resolvedArtifact, group);
            map.put((ReifiedArtifact)destination, resolvedArtifact);
            Arrays.asList(listeners).forEach(listener -> listener.artifactFetched(resolvedArtifact));
            return groupTraversalRule.transitive;
        });
        return resolvedGraph;
    }

    private boolean checkCompatibilityAndAddToGraph(DependencyGraph graph, Map<ArtifactID, ReifiedArtifact> artifacts, DependencyGraph.Dependency destination, List<Graph.Edge<DependencyGraph.Dependency, DependencyEdgeValue>> inboundEdges, ArtifactGraph artifactGraph) {
        List<Graph.Edge> significantInbound = inboundEdges.stream().filter(edge -> artifacts.containsKey(((DependencyGraph.Dependency)edge.getOrigin()).id)).filter(edge -> ((DependencyEdgeValue)edge.getValue()).dependentVersion.equals((Object)((ReifiedArtifact)artifacts.get((Object)((DependencyGraph.Dependency)edge.getOrigin()).id)).version)).collect(Collectors.toList());
        Version min = significantInbound.stream().map(edge -> ((DependencyEdgeValue)edge.getValue()).dependencyVersion).min(Version::compareTo).orElse(null);
        Version max = significantInbound.stream().map(edge -> ((DependencyEdgeValue)edge.getValue()).dependencyVersion).max(Version::compareTo).orElse(null);
        this.output.debugln("Min [%s] and max [%s]", new Object[]{min, max});
        if (min == null || max == null) {
            this.output.debugln("NO LONGER USED", new Object[0]);
            return false;
        }
        if (!destination.skipCompatibilityCheck && !min.isCompatibleWith(max)) {
            this.output.debugln("INCOMPATIBLE", new Object[0]);
            throw new CompatibilityException(graph, destination, min, max);
        }
        DependencyEdgeValue edgeValue = (DependencyEdgeValue)significantInbound.stream().filter(edge -> ((DependencyEdgeValue)edge.getValue()).dependencyVersion.equals((Object)max)).findFirst().get().getValue();
        ReifiedArtifact destinationArtifact = new ReifiedArtifact(destination.id, max, edgeValue.licenses);
        artifacts.put(destination.id, destinationArtifact);
        significantInbound.forEach(edge -> {
            ReifiedArtifact originArtifact = (ReifiedArtifact)artifacts.get(((DependencyGraph.Dependency)edge.getOrigin()).id);
            artifactGraph.addEdge(originArtifact, destinationArtifact, ((DependencyEdgeValue)edge.getValue()).type);
        });
        return true;
    }

    private void populateGraph(DependencyGraph graph, ReifiedArtifact origin, Dependencies dependencies, Workflow workflow, Set<Artifact> artifactsRecursed) throws ArtifactMetaDataMissingException, ProcessFailureException, MD5Exception {
        dependencies.groups.forEach((type, group) -> {
            this.output.debugln("Loading dependency group [%s]", new Object[]{type});
            for (Artifact dependency : group.dependencies) {
                this.output.debugln("Loading dependency [%s] skipCompatibilityCheck=[%b]", new Object[]{dependency, dependency.skipCompatibilityCheck});
                ArtifactMetaData amd = workflow.fetchMetaData(dependency);
                DependencyEdgeValue edge = new DependencyEdgeValue(origin.version, dependency.version, (String)type, amd.licenses);
                graph.addEdge(new DependencyGraph.Dependency(origin.id), new DependencyGraph.Dependency(dependency.id), edge);
                if (dependency.skipCompatibilityCheck) {
                    this.output.debugln("SKIPPING COMPATIBILITY CHECK for [%s]", new Object[]{dependency.id});
                    graph.skipCompatibilityCheck(dependency.id);
                }
                if (artifactsRecursed.contains(dependency)) continue;
                if (amd.dependencies != null) {
                    ReifiedArtifact artifact = amd.toLicensedArtifact(dependency);
                    this.populateGraph(graph, artifact, amd.dependencies, workflow, artifactsRecursed);
                }
                artifactsRecursed.add(dependency);
            }
        });
    }

    private void publishItem(Artifact artifact, String item, Path file, PublishWorkflow workflow) throws IOException {
        MD5 md5 = MD5.forPath((Path)file);
        File tempFile = File.createTempFile("artifact-item", "md5");
        tempFile.deleteOnExit();
        Path md5File = tempFile.toPath();
        MD5.writeMD5((MD5)md5, (Path)md5File);
        workflow.publish(artifact, item + ".md5", md5File);
        workflow.publish(artifact, item, file);
    }
}

