/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.parser.chunking;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import opennlp.maxent.GIS;
import opennlp.model.AbstractModel;
import opennlp.model.DataIndexer;
import opennlp.model.EventStream;
import opennlp.model.MaxentModel;
import opennlp.model.TrainUtil;
import opennlp.model.TwoPassDataIndexer;
import opennlp.tools.chunker.ChunkSample;
import opennlp.tools.chunker.Chunker;
import opennlp.tools.chunker.ChunkerME;
import opennlp.tools.chunker.ChunkerModel;
import opennlp.tools.dictionary.Dictionary;
import opennlp.tools.parser.AbstractBottomUpParser;
import opennlp.tools.parser.ChunkContextGenerator;
import opennlp.tools.parser.ChunkSampleStream;
import opennlp.tools.parser.HeadRules;
import opennlp.tools.parser.Parse;
import opennlp.tools.parser.ParserChunkerSequenceValidator;
import opennlp.tools.parser.ParserEventTypeEnum;
import opennlp.tools.parser.ParserModel;
import opennlp.tools.parser.ParserType;
import opennlp.tools.parser.PosSampleStream;
import opennlp.tools.parser.chunking.BuildContextGenerator;
import opennlp.tools.parser.chunking.CheckContextGenerator;
import opennlp.tools.parser.chunking.ParserEventStream;
import opennlp.tools.postag.POSModel;
import opennlp.tools.postag.POSTagger;
import opennlp.tools.postag.POSTaggerME;
import opennlp.tools.util.ObjectStream;
import opennlp.tools.util.Span;
import opennlp.tools.util.TrainingParameters;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Parser
extends AbstractBottomUpParser {
    private MaxentModel buildModel;
    private MaxentModel checkModel;
    private BuildContextGenerator buildContextGenerator;
    private CheckContextGenerator checkContextGenerator;
    private double[] bprobs;
    private double[] cprobs;
    private static final String TOP_START = "S-TOP";
    private int topStartIndex;
    private Map<String, String> startTypeMap;
    private Map<String, String> contTypeMap;
    private int completeIndex;
    private int incompleteIndex;

    public Parser(ParserModel model, int beamSize, double advancePercentage) {
        this((MaxentModel)model.getBuildModel(), (MaxentModel)model.getCheckModel(), new POSTaggerME(model.getParserTaggerModel(), 10, 0), new ChunkerME(model.getParserChunkerModel(), 10, new ParserChunkerSequenceValidator(model.getParserChunkerModel()), new ChunkContextGenerator(10)), model.getHeadRules(), beamSize, advancePercentage);
    }

    public Parser(ParserModel model) {
        this(model, 20, 0.95);
    }

    @Deprecated
    public Parser(MaxentModel buildModel, MaxentModel checkModel, POSTagger tagger, Chunker chunker, HeadRules headRules) {
        this(buildModel, checkModel, tagger, chunker, headRules, 20, 0.95);
    }

    @Deprecated
    public Parser(MaxentModel buildModel, MaxentModel checkModel, POSTagger tagger, Chunker chunker, HeadRules headRules, int beamSize, double advancePercentage) {
        super(tagger, chunker, headRules, beamSize, advancePercentage);
        this.buildModel = buildModel;
        this.checkModel = checkModel;
        this.bprobs = new double[buildModel.getNumOutcomes()];
        this.cprobs = new double[checkModel.getNumOutcomes()];
        this.buildContextGenerator = new BuildContextGenerator();
        this.checkContextGenerator = new CheckContextGenerator();
        this.startTypeMap = new HashMap<String, String>();
        this.contTypeMap = new HashMap<String, String>();
        int bon = buildModel.getNumOutcomes();
        for (int boi = 0; boi < bon; ++boi) {
            String outcome = buildModel.getOutcome(boi);
            if (outcome.startsWith("S-")) {
                this.startTypeMap.put(outcome, outcome.substring("S-".length()));
                continue;
            }
            if (!outcome.startsWith("C-")) continue;
            this.contTypeMap.put(outcome, outcome.substring("C-".length()));
        }
        this.topStartIndex = buildModel.getIndex(TOP_START);
        this.completeIndex = checkModel.getIndex("c");
        this.incompleteIndex = checkModel.getIndex("i");
    }

    @Override
    protected void advanceTop(Parse p) {
        this.buildModel.eval(this.buildContextGenerator.getContext(p.getChildren(), 0), this.bprobs);
        p.addProb(Math.log(this.bprobs[this.topStartIndex]));
        this.checkModel.eval(this.checkContextGenerator.getContext(p.getChildren(), "TOP", 0, 0), this.cprobs);
        p.addProb(Math.log(this.cprobs[this.completeIndex]));
        p.setType("TOP");
    }

    @Override
    protected Parse[] advanceParses(Parse p, double probMass) {
        int advanceNodeIndex;
        double q = 1.0 - probMass;
        Parse lastStartNode = null;
        int lastStartIndex = -1;
        String lastStartType = null;
        Parse advanceNode = null;
        Parse[] originalChildren = p.getChildren();
        Parse[] children = Parser.collapsePunctuation(originalChildren, this.punctSet);
        int numNodes = children.length;
        if (numNodes == 0) {
            return null;
        }
        for (advanceNodeIndex = 0; advanceNodeIndex < numNodes && (advanceNode = children[advanceNodeIndex]).getLabel() != null; ++advanceNodeIndex) {
            if (!this.startTypeMap.containsKey(advanceNode.getLabel())) continue;
            lastStartType = this.startTypeMap.get(advanceNode.getLabel());
            lastStartNode = advanceNode;
            lastStartIndex = advanceNodeIndex;
        }
        int originalAdvanceIndex = this.mapParseIndex(advanceNodeIndex, children, originalChildren);
        ArrayList<Parse> newParsesList = new ArrayList<Parse>(this.buildModel.getNumOutcomes());
        this.buildModel.eval(this.buildContextGenerator.getContext(children, advanceNodeIndex), this.bprobs);
        double bprobSum = 0.0;
        while (bprobSum < probMass) {
            int max = 0;
            for (int pi = 1; pi < this.bprobs.length; ++pi) {
                if (!(this.bprobs[pi] > this.bprobs[max])) continue;
                max = pi;
            }
            if (this.bprobs[max] == 0.0) break;
            double bprob = this.bprobs[max];
            this.bprobs[max] = 0.0;
            bprobSum += bprob;
            String tag = this.buildModel.getOutcome(max);
            if (max == this.topStartIndex) continue;
            if (this.startTypeMap.containsKey(tag)) {
                lastStartIndex = advanceNodeIndex;
                lastStartNode = advanceNode;
                lastStartType = this.startTypeMap.get(tag);
            } else if (this.contTypeMap.containsKey(tag) && (lastStartNode == null || !lastStartType.equals(this.contTypeMap.get(tag)))) continue;
            Parse newParse1 = (Parse)p.clone();
            if (this.createDerivationString) {
                newParse1.getDerivation().append(max).append("-");
            }
            newParse1.setChild(originalAdvanceIndex, tag);
            newParse1.addProb(Math.log(bprob));
            this.checkModel.eval(this.checkContextGenerator.getContext(Parser.collapsePunctuation(newParse1.getChildren(), this.punctSet), lastStartType, lastStartIndex, advanceNodeIndex), this.cprobs);
            Parse newParse2 = newParse1;
            if (this.cprobs[this.completeIndex] > q) {
                newParse2 = (Parse)newParse1.clone();
                if (this.createDerivationString) {
                    newParse2.getDerivation().append(1).append(".");
                }
                newParse2.addProb(Math.log(this.cprobs[this.completeIndex]));
                Parse[] cons = new Parse[advanceNodeIndex - lastStartIndex + 1];
                boolean flat = true;
                cons[0] = lastStartNode;
                flat &= cons[0].isPosTag();
                cons[advanceNodeIndex - lastStartIndex] = advanceNode;
                flat &= cons[advanceNodeIndex - lastStartIndex].isPosTag();
                for (int ci = 1; ci < advanceNodeIndex - lastStartIndex; ++ci) {
                    cons[ci] = children[ci + lastStartIndex];
                    flat &= cons[ci].isPosTag();
                }
                if (!flat) {
                    if (lastStartIndex == 0 && advanceNodeIndex == numNodes - 1) {
                        newParse2.insert(new Parse(p.getText(), p.getSpan(), lastStartType, this.cprobs[1], this.headRules.getHead(cons, lastStartType)));
                    } else {
                        newParse2.insert(new Parse(p.getText(), new Span(lastStartNode.getSpan().getStart(), advanceNode.getSpan().getEnd()), lastStartType, this.cprobs[1], this.headRules.getHead(cons, lastStartType)));
                    }
                    newParsesList.add(newParse2);
                }
            }
            if (!(this.cprobs[this.incompleteIndex] > q)) continue;
            if (this.createDerivationString) {
                newParse1.getDerivation().append(0).append(".");
            }
            if (advanceNodeIndex == numNodes - 1) continue;
            newParse1.addProb(Math.log(this.cprobs[this.incompleteIndex]));
            newParsesList.add(newParse1);
        }
        Parse[] newParses = new Parse[newParsesList.size()];
        newParsesList.toArray(newParses);
        return newParses;
    }

    @Deprecated
    public static AbstractModel train(EventStream es, int iterations, int cut) throws IOException {
        return GIS.trainModel((int)iterations, (DataIndexer)new TwoPassDataIndexer(es, cut));
    }

    public static void mergeReportIntoManifest(Map<String, String> manifest, Map<String, String> report, String namespace) {
        for (Map.Entry<String, String> entry : report.entrySet()) {
            manifest.put(namespace + "." + entry.getKey(), entry.getValue());
        }
    }

    public static ParserModel train(String languageCode, ObjectStream<Parse> parseSamples, HeadRules rules, TrainingParameters mlParams) throws IOException {
        System.err.println("Building dictionary");
        Dictionary mdict = Parser.buildDictionary(parseSamples, rules, mlParams);
        parseSamples.reset();
        HashMap<String, String> manifestInfoEntries = new HashMap<String, String>();
        System.err.println("Training builder");
        ParserEventStream bes = new ParserEventStream(parseSamples, rules, ParserEventTypeEnum.BUILD, mdict);
        HashMap<String, String> buildReportMap = new HashMap<String, String>();
        AbstractModel buildModel = TrainUtil.train((EventStream)bes, mlParams.getSettings("build"), buildReportMap);
        Parser.mergeReportIntoManifest(manifestInfoEntries, buildReportMap, "build");
        parseSamples.reset();
        POSModel posModel = POSTaggerME.train(languageCode, new PosSampleStream(parseSamples), mlParams.getParameters("tagger"), null, null);
        parseSamples.reset();
        ChunkerModel chunkModel = ChunkerME.train(languageCode, (ObjectStream<ChunkSample>)new ChunkSampleStream(parseSamples), new ChunkContextGenerator(), mlParams.getParameters("chunker"));
        parseSamples.reset();
        System.err.println("Training checker");
        ParserEventStream kes = new ParserEventStream(parseSamples, rules, ParserEventTypeEnum.CHECK);
        HashMap<String, String> checkReportMap = new HashMap<String, String>();
        AbstractModel checkModel = TrainUtil.train((EventStream)kes, mlParams.getSettings("check"), checkReportMap);
        Parser.mergeReportIntoManifest(manifestInfoEntries, checkReportMap, "check");
        return new ParserModel(languageCode, buildModel, checkModel, posModel, chunkModel, (opennlp.tools.parser.lang.en.HeadRules)rules, ParserType.CHUNKING, manifestInfoEntries);
    }

    @Deprecated
    public static ParserModel train(String languageCode, ObjectStream<Parse> parseSamples, HeadRules rules, int iterations, int cut) throws IOException {
        TrainingParameters params = new TrainingParameters();
        params.put("dict", "Cutoff", Integer.toString(cut));
        params.put("tagger", "Cutoff", Integer.toString(cut));
        params.put("tagger", "Iterations", Integer.toString(iterations));
        params.put("chunker", "Cutoff", Integer.toString(cut));
        params.put("chunker", "Iterations", Integer.toString(iterations));
        params.put("check", "Cutoff", Integer.toString(cut));
        params.put("check", "Iterations", Integer.toString(iterations));
        params.put("build", "Cutoff", Integer.toString(cut));
        params.put("build", "Iterations", Integer.toString(iterations));
        return Parser.train(languageCode, parseSamples, rules, params);
    }
}

