/*
 * Decompiled with CFR 0.152.
 */
package org.primeframework.mvc.test;

import com.google.inject.Injector;
import io.fusionauth.http.server.HTTPListenerConfiguration;
import org.primeframework.mock.MockUserAgent;
import org.primeframework.mvc.BasePrimeMain;
import org.primeframework.mvc.TestPrimeMainThread;
import org.primeframework.mvc.message.TestMessageObserver;
import org.primeframework.mvc.test.RequestBuilder;

public class RequestSimulator {
    public final BasePrimeMain main;
    public final TestMessageObserver messageObserver;
    public final TestPrimeMainThread thread;
    public int actualPort = -1;
    public int port;
    public int tlsPort;
    public boolean useTLS;
    public MockUserAgent userAgent;

    public RequestSimulator(BasePrimeMain basePrimeMain, TestMessageObserver testMessageObserver) {
        this.main = basePrimeMain;
        this.thread = new TestPrimeMainThread(basePrimeMain);
        this.messageObserver = testMessageObserver;
        this.userAgent = new MockUserAgent();
        this.port = ((HTTPListenerConfiguration)basePrimeMain.configuration()[0].configuration().getListeners().get(0)).getPort();
    }

    public RequestSimulator(BasePrimeMain basePrimeMain, TestMessageObserver testMessageObserver, int n) {
        this.main = basePrimeMain;
        this.thread = new TestPrimeMainThread(basePrimeMain);
        this.messageObserver = testMessageObserver;
        this.userAgent = new MockUserAgent();
        this.port = n;
    }

    public RequestSimulator(BasePrimeMain basePrimeMain, TestMessageObserver testMessageObserver, int n, int n2) {
        this.main = basePrimeMain;
        this.thread = new TestPrimeMainThread(basePrimeMain);
        this.messageObserver = testMessageObserver;
        this.userAgent = new MockUserAgent();
        this.port = n;
        this.tlsPort = n2;
    }

    public Injector getInjector() {
        return this.main.getInjector();
    }

    public int getPort() {
        return this.actualPort != -1 ? this.actualPort : this.port;
    }

    public void reset() {
        this.actualPort = -1;
        this.userAgent = new MockUserAgent();
        this.useTLS = false;
    }

    public void shutdown() {
        this.actualPort = -1;
        this.thread.shutdown();
        this.useTLS = false;
    }

    public RequestBuilder test(String string) {
        this.actualPort = this.useTLS ? this.tlsPort : this.port;
        RequestBuilder requestBuilder = new RequestBuilder(string, this.main.getInjector(), this.userAgent, this.messageObserver, this.actualPort);
        requestBuilder.useTLS = this.useTLS;
        return requestBuilder;
    }

    public RequestSimulator withTLS(boolean bl) {
        this.useTLS = bl;
        return this;
    }
}

