/*
 * Decompiled with CFR 0.152.
 */
package org.primeframework.mvc.http;

import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import org.primeframework.mvc.http.MultipartBodyHandler;
import org.primeframework.mvc.http.MultipartFileUpload;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test
public class MultipartBodyHandlerTest {
    @Test
    public void post_formData_multiPart() throws Exception {
        LinkedHashMap<String, List<String>> linkedHashMap = new LinkedHashMap<String, List<String>>();
        linkedHashMap.put("test1", Collections.singletonList("value1"));
        linkedHashMap.put("test2", Collections.singletonList("value2 with space"));
        ArrayList<MultipartFileUpload> arrayList = new ArrayList<MultipartFileUpload>();
        arrayList.add(new MultipartFileUpload("text/plain", Paths.get("src/test/java/org/primeframework/mvc/http/test-file.txt", new String[0]), "foo.bar.txt", "formField"));
        MultipartBodyHandler.Multiparts multiparts = new MultipartBodyHandler.Multiparts(arrayList, linkedHashMap);
        MultipartBodyHandler multipartBodyHandler = new MultipartBodyHandler(multiparts);
        String string = "--" + multipartBodyHandler.boundary + "\r\nContent-Disposition: form-data; name=\"formField\"; filename=\"foo.bar.txt\"; filename*=UTF-8''foo.bar.txt\r\nContent-Type: text/plain\r\n\r\n1234\n\r\n--" + multipartBodyHandler.boundary + "\r\nContent-Disposition: form-data; name=\"test1\"\r\n\r\nvalue1\r\n--" + multipartBodyHandler.boundary + "\r\nContent-Disposition: form-data; name=\"test2\"\r\n\r\nvalue2 with space\r\n--" + multipartBodyHandler.boundary + "--";
        byte[] byArray = multipartBodyHandler.getBody();
        Assert.assertEquals((String)new String(byArray), (String)string);
    }
}

