/*
 * Decompiled with CFR 0.152.
 */
package org.primeframework.mvc.action.result;

import io.fusionauth.http.server.HTTPRequest;
import io.fusionauth.http.server.HTTPResponse;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import org.easymock.EasyMock;
import org.primeframework.mvc.PrimeBaseTest;
import org.primeframework.mvc.action.ActionInvocation;
import org.primeframework.mvc.action.ActionInvocationStore;
import org.primeframework.mvc.action.result.RedirectResult;
import org.primeframework.mvc.action.result.annotation.Redirect;
import org.primeframework.mvc.message.MessageStore;
import org.primeframework.mvc.message.scope.MessageScope;
import org.primeframework.mvc.parameter.el.ExpressionEvaluator;
import org.testng.Assert;
import org.testng.annotations.Test;

public class RedirectResultTest
extends PrimeBaseTest {
    @Test
    public void encode() throws IOException {
        Object object = new Object();
        ExpressionEvaluator expressionEvaluator = (ExpressionEvaluator)EasyMock.createStrictMock(ExpressionEvaluator.class);
        EasyMock.expect((Object)expressionEvaluator.expand("${foo}", object, true)).andReturn((Object)"result");
        EasyMock.replay((Object[])new Object[]{expressionEvaluator});
        ArrayList arrayList = new ArrayList();
        HTTPRequest hTTPRequest2 = (HTTPRequest)new HTTPRequest().with(hTTPRequest -> hTTPRequest.setPath("/"));
        HTTPResponse hTTPResponse = new HTTPResponse();
        ActionInvocationStore actionInvocationStore = (ActionInvocationStore)EasyMock.createStrictMock(ActionInvocationStore.class);
        EasyMock.expect((Object)actionInvocationStore.getCurrent()).andReturn((Object)new ActionInvocation(object, null, "foo", "", null));
        EasyMock.replay((Object[])new Object[]{actionInvocationStore});
        MessageStore messageStore = (MessageStore)EasyMock.createStrictMock(MessageStore.class);
        EasyMock.expect((Object)messageStore.get(MessageScope.REQUEST)).andReturn(arrayList);
        messageStore.clear(MessageScope.REQUEST);
        messageStore.addAll(MessageScope.FLASH, arrayList);
        EasyMock.replay((Object[])new Object[]{messageStore});
        RedirectImpl redirectImpl = new RedirectImpl("success", "${foo}", false, true);
        RedirectResult redirectResult = new RedirectResult(messageStore, expressionEvaluator, hTTPResponse, hTTPRequest2, actionInvocationStore);
        redirectResult.execute((Redirect)redirectImpl);
        Assert.assertEquals((int)hTTPResponse.getStatus(), (int)302);
        Assert.assertEquals((String)hTTPResponse.getRedirect(), (String)"result");
        Assert.assertEquals((String)hTTPResponse.getHeader("Cache-Control"), (String)"no-cache");
    }

    @Test
    public void expand() throws IOException {
        Object object = new Object();
        ExpressionEvaluator expressionEvaluator = (ExpressionEvaluator)EasyMock.createStrictMock(ExpressionEvaluator.class);
        EasyMock.expect((Object)expressionEvaluator.expand("${foo}", object, false)).andReturn((Object)"result");
        EasyMock.replay((Object[])new Object[]{expressionEvaluator});
        ArrayList arrayList = new ArrayList();
        HTTPRequest hTTPRequest = new HTTPRequest();
        HTTPResponse hTTPResponse = new HTTPResponse();
        ActionInvocationStore actionInvocationStore = (ActionInvocationStore)EasyMock.createStrictMock(ActionInvocationStore.class);
        EasyMock.expect((Object)actionInvocationStore.getCurrent()).andReturn((Object)new ActionInvocation(object, null, "foo", "", null));
        EasyMock.replay((Object[])new Object[]{actionInvocationStore});
        MessageStore messageStore = (MessageStore)EasyMock.createStrictMock(MessageStore.class);
        EasyMock.expect((Object)messageStore.get(MessageScope.REQUEST)).andReturn(arrayList);
        messageStore.clear(MessageScope.REQUEST);
        messageStore.addAll(MessageScope.FLASH, arrayList);
        EasyMock.replay((Object[])new Object[]{messageStore});
        RedirectImpl redirectImpl = new RedirectImpl("success", "${foo}", false, false);
        RedirectResult redirectResult = new RedirectResult(messageStore, expressionEvaluator, hTTPResponse, hTTPRequest, actionInvocationStore);
        redirectResult.execute((Redirect)redirectImpl);
        Assert.assertEquals((int)hTTPResponse.getStatus(), (int)302);
        Assert.assertEquals((String)hTTPResponse.getRedirect(), (String)"result");
        Assert.assertEquals((String)hTTPResponse.getHeader("Cache-Control"), (String)"no-cache");
    }

    @Test
    public void fullyQualified() throws IOException {
        ExpressionEvaluator expressionEvaluator = (ExpressionEvaluator)EasyMock.createStrictMock(ExpressionEvaluator.class);
        EasyMock.replay((Object[])new Object[]{expressionEvaluator});
        ArrayList arrayList = new ArrayList();
        HTTPRequest hTTPRequest = new HTTPRequest();
        HTTPResponse hTTPResponse = new HTTPResponse();
        ActionInvocationStore actionInvocationStore = (ActionInvocationStore)EasyMock.createStrictMock(ActionInvocationStore.class);
        EasyMock.expect((Object)actionInvocationStore.getCurrent()).andReturn((Object)new ActionInvocation(null, null, "/foo", "", null));
        EasyMock.replay((Object[])new Object[]{actionInvocationStore});
        MessageStore messageStore = (MessageStore)EasyMock.createStrictMock(MessageStore.class);
        EasyMock.expect((Object)messageStore.get(MessageScope.REQUEST)).andReturn(arrayList);
        messageStore.clear(MessageScope.REQUEST);
        messageStore.addAll(MessageScope.FLASH, arrayList);
        EasyMock.replay((Object[])new Object[]{messageStore});
        RedirectImpl redirectImpl = new RedirectImpl("success", "http://www.google.com", true, false);
        RedirectResult redirectResult = new RedirectResult(messageStore, expressionEvaluator, hTTPResponse, hTTPRequest, actionInvocationStore);
        redirectResult.execute((Redirect)redirectImpl);
        Assert.assertEquals((int)hTTPResponse.getStatus(), (int)301);
        Assert.assertEquals((String)hTTPResponse.getRedirect(), (String)"http://www.google.com");
        Assert.assertEquals((String)hTTPResponse.getHeader("Cache-Control"), (String)"no-cache");
    }

    @Test
    public void relative() throws IOException {
        ExpressionEvaluator expressionEvaluator = (ExpressionEvaluator)EasyMock.createStrictMock(ExpressionEvaluator.class);
        EasyMock.replay((Object[])new Object[]{expressionEvaluator});
        ArrayList arrayList = new ArrayList();
        HTTPRequest hTTPRequest = new HTTPRequest();
        HTTPResponse hTTPResponse = new HTTPResponse();
        ActionInvocationStore actionInvocationStore = (ActionInvocationStore)EasyMock.createStrictMock(ActionInvocationStore.class);
        EasyMock.expect((Object)actionInvocationStore.getCurrent()).andReturn((Object)new ActionInvocation(null, null, "foo", "", null));
        EasyMock.replay((Object[])new Object[]{actionInvocationStore});
        MessageStore messageStore = (MessageStore)EasyMock.createStrictMock(MessageStore.class);
        EasyMock.expect((Object)messageStore.get(MessageScope.REQUEST)).andReturn(arrayList);
        messageStore.clear(MessageScope.REQUEST);
        messageStore.addAll(MessageScope.FLASH, arrayList);
        EasyMock.replay((Object[])new Object[]{messageStore});
        RedirectImpl redirectImpl = new RedirectImpl("success", "/foo/bar.jsp", false, false);
        RedirectResult redirectResult = new RedirectResult(messageStore, expressionEvaluator, hTTPResponse, hTTPRequest, actionInvocationStore);
        redirectResult.execute((Redirect)redirectImpl);
        Assert.assertEquals((int)hTTPResponse.getStatus(), (int)302);
        Assert.assertEquals((String)hTTPResponse.getRedirect(), (String)"/foo/bar.jsp");
        Assert.assertEquals((String)hTTPResponse.getHeader("Cache-Control"), (String)"no-cache");
    }

    @Test
    public void relativeContext() throws IOException {
        ExpressionEvaluator expressionEvaluator = (ExpressionEvaluator)EasyMock.createStrictMock(ExpressionEvaluator.class);
        EasyMock.replay((Object[])new Object[]{expressionEvaluator});
        ArrayList arrayList = new ArrayList();
        HTTPRequest hTTPRequest2 = (HTTPRequest)new HTTPRequest().with(hTTPRequest -> hTTPRequest.setContextPath("/context-path"));
        HTTPResponse hTTPResponse = new HTTPResponse();
        ActionInvocationStore actionInvocationStore = (ActionInvocationStore)EasyMock.createStrictMock(ActionInvocationStore.class);
        EasyMock.expect((Object)actionInvocationStore.getCurrent()).andReturn((Object)new ActionInvocation(null, null, "foo", "", null));
        EasyMock.replay((Object[])new Object[]{actionInvocationStore});
        MessageStore messageStore = (MessageStore)EasyMock.createStrictMock(MessageStore.class);
        EasyMock.expect((Object)messageStore.get(MessageScope.REQUEST)).andReturn(arrayList);
        messageStore.clear(MessageScope.REQUEST);
        messageStore.addAll(MessageScope.FLASH, arrayList);
        EasyMock.replay((Object[])new Object[]{messageStore});
        RedirectImpl redirectImpl = new RedirectImpl("success", "/foo/bar.jsp", false, false);
        RedirectResult redirectResult = new RedirectResult(messageStore, expressionEvaluator, hTTPResponse, hTTPRequest2, actionInvocationStore);
        redirectResult.execute((Redirect)redirectImpl);
        Assert.assertEquals((int)hTTPResponse.getStatus(), (int)302);
        Assert.assertEquals((String)hTTPResponse.getRedirect(), (String)"/context-path/foo/bar.jsp");
        Assert.assertEquals((String)hTTPResponse.getHeader("Cache-Control"), (String)"no-cache");
    }

    @Test
    public void relativeContextNoSlash() throws IOException {
        ExpressionEvaluator expressionEvaluator = (ExpressionEvaluator)EasyMock.createStrictMock(ExpressionEvaluator.class);
        EasyMock.replay((Object[])new Object[]{expressionEvaluator});
        ArrayList arrayList = new ArrayList();
        HTTPRequest hTTPRequest2 = (HTTPRequest)new HTTPRequest().with(hTTPRequest -> hTTPRequest.setContextPath("/context-path"));
        HTTPResponse hTTPResponse = new HTTPResponse();
        ActionInvocationStore actionInvocationStore = (ActionInvocationStore)EasyMock.createStrictMock(ActionInvocationStore.class);
        EasyMock.expect((Object)actionInvocationStore.getCurrent()).andReturn((Object)new ActionInvocation(null, null, "foo", "", null));
        EasyMock.replay((Object[])new Object[]{actionInvocationStore});
        MessageStore messageStore = (MessageStore)EasyMock.createStrictMock(MessageStore.class);
        EasyMock.expect((Object)messageStore.get(MessageScope.REQUEST)).andReturn(arrayList);
        messageStore.clear(MessageScope.REQUEST);
        messageStore.addAll(MessageScope.FLASH, arrayList);
        EasyMock.replay((Object[])new Object[]{messageStore});
        RedirectImpl redirectImpl = new RedirectImpl("success", "foo/bar.jsp", false, false);
        RedirectResult redirectResult = new RedirectResult(messageStore, expressionEvaluator, hTTPResponse, hTTPRequest2, actionInvocationStore);
        redirectResult.execute((Redirect)redirectImpl);
        Assert.assertEquals((int)hTTPResponse.getStatus(), (int)302);
        Assert.assertEquals((String)hTTPResponse.getRedirect(), (String)"foo/bar.jsp");
        Assert.assertEquals((String)hTTPResponse.getHeader("Cache-Control"), (String)"no-cache");
    }

    public static class RedirectImpl
    implements Redirect {
        private final String cacheControl;
        private final String code;
        private final boolean disableCacheControl;
        private final boolean encode;
        private final boolean perm;
        private final String uri;

        public RedirectImpl(String string, String string2, boolean bl, boolean bl2) {
            this.cacheControl = "no-cache";
            this.code = string;
            this.disableCacheControl = false;
            this.encode = bl2;
            this.perm = bl;
            this.uri = string2;
        }

        public Class<? extends Annotation> annotationType() {
            return Redirect.class;
        }

        public String cacheControl() {
            return this.cacheControl;
        }

        public String code() {
            return this.code;
        }

        public boolean disableCacheControl() {
            return this.disableCacheControl;
        }

        public boolean encodeVariables() {
            return this.encode;
        }

        public boolean perm() {
            return this.perm;
        }

        public String uri() {
            return this.uri;
        }
    }
}

