/*
 * Decompiled with CFR 0.152.
 */
package org.primeframework.mvc.action.result;

import com.google.inject.Binder;
import com.google.inject.Injector;
import io.fusionauth.http.HTTPMethod;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.easymock.EasyMock;
import org.example.action.user.EditAction;
import org.primeframework.mvc.PrimeBaseTest;
import org.primeframework.mvc.PrimeException;
import org.primeframework.mvc.action.ActionInvocation;
import org.primeframework.mvc.action.ActionInvocationStore;
import org.primeframework.mvc.action.ExecuteMethodConfiguration;
import org.primeframework.mvc.action.config.ActionConfiguration;
import org.primeframework.mvc.action.result.DefaultResultInvocationWorkflow;
import org.primeframework.mvc.action.result.ForwardResult;
import org.primeframework.mvc.action.result.RedirectResult;
import org.primeframework.mvc.action.result.ResourceLocator;
import org.primeframework.mvc.action.result.ResultFactory;
import org.primeframework.mvc.action.result.ResultStore;
import org.primeframework.mvc.action.result.annotation.Forward;
import org.primeframework.mvc.action.result.annotation.Redirect;
import org.primeframework.mvc.config.MVCConfiguration;
import org.primeframework.mvc.validation.Validation;
import org.primeframework.mvc.workflow.WorkflowChain;
import org.testng.Assert;
import org.testng.annotations.Test;

public class DefaultResultInvocationWorkflowTest
extends PrimeBaseTest {
    @Test
    public void actionLessWithDefaultForward() throws Exception {
        ActionInvocation actionInvocation = new ActionInvocation(null, null, "/foo/bar", null, null);
        ActionInvocationStore actionInvocationStore = (ActionInvocationStore)EasyMock.createStrictMock(ActionInvocationStore.class);
        EasyMock.expect((Object)actionInvocationStore.getCurrent()).andReturn((Object)actionInvocation);
        EasyMock.replay((Object[])new Object[]{actionInvocationStore});
        WorkflowChain workflowChain = (WorkflowChain)EasyMock.createStrictMock(WorkflowChain.class);
        EasyMock.replay((Object[])new Object[]{workflowChain});
        ResultStore resultStore = (ResultStore)EasyMock.createStrictMock(ResultStore.class);
        EasyMock.replay((Object[])new Object[]{resultStore});
        ResourceLocator resourceLocator = (ResourceLocator)EasyMock.createStrictMock(ResourceLocator.class);
        EasyMock.replay((Object[])new Object[]{resourceLocator});
        ForwardResult forwardResult = (ForwardResult)EasyMock.createStrictMock(ForwardResult.class);
        EasyMock.expect((Object)forwardResult.execute((Annotation)((Forward)EasyMock.isA(Forward.class)))).andReturn((Object)true);
        EasyMock.replay((Object[])new Object[]{forwardResult});
        Injector injector = (Injector)EasyMock.createStrictMock(Injector.class);
        EasyMock.expect((Object)((ForwardResult)injector.getInstance(ForwardResult.class))).andReturn((Object)forwardResult);
        EasyMock.replay((Object[])new Object[]{injector});
        Binder binder = (Binder)EasyMock.createStrictMock(Binder.class);
        EasyMock.expect((Object)binder.bind(ForwardResult.class)).andReturn(null);
        EasyMock.replay((Object[])new Object[]{binder});
        ResultFactory.addResult((Binder)binder, Forward.class, ForwardResult.class);
        ResultFactory resultFactory = new ResultFactory(injector);
        DefaultResultInvocationWorkflow defaultResultInvocationWorkflow = new DefaultResultInvocationWorkflow(actionInvocationStore, (MVCConfiguration)configuration, Map.of(), resultStore, resourceLocator, resultFactory);
        defaultResultInvocationWorkflow.perform(workflowChain);
        EasyMock.verify((Object[])new Object[]{actionInvocationStore, resultStore, resourceLocator, injector, workflowChain, binder});
    }

    @Test
    public void actionLessWithDefaultRedirect() throws Exception {
        ActionInvocation actionInvocation = new ActionInvocation(null, null, "/foo/bar", null, null);
        ActionInvocationStore actionInvocationStore = (ActionInvocationStore)EasyMock.createStrictMock(ActionInvocationStore.class);
        EasyMock.expect((Object)actionInvocationStore.getCurrent()).andReturn((Object)actionInvocation);
        EasyMock.replay((Object[])new Object[]{actionInvocationStore});
        ResultStore resultStore = (ResultStore)EasyMock.createStrictMock(ResultStore.class);
        EasyMock.replay((Object[])new Object[]{resultStore});
        ResourceLocator resourceLocator = (ResourceLocator)EasyMock.createStrictMock(ResourceLocator.class);
        EasyMock.expect((Object)resourceLocator.locateIndex(configuration.templateDirectory())).andReturn((Object)"/foo/bar/");
        EasyMock.replay((Object[])new Object[]{resourceLocator});
        ForwardResult forwardResult = (ForwardResult)EasyMock.createStrictMock(ForwardResult.class);
        EasyMock.expect((Object)forwardResult.execute((Annotation)((Forward)EasyMock.isA(Forward.class)))).andReturn((Object)false);
        EasyMock.replay((Object[])new Object[]{forwardResult});
        RedirectResult redirectResult = (RedirectResult)EasyMock.createStrictMock(RedirectResult.class);
        EasyMock.expect((Object)redirectResult.execute((Redirect)EasyMock.isA(Redirect.class))).andReturn((Object)true);
        EasyMock.replay((Object[])new Object[]{redirectResult});
        Injector injector = (Injector)EasyMock.createStrictMock(Injector.class);
        EasyMock.expect((Object)((ForwardResult)injector.getInstance(ForwardResult.class))).andReturn((Object)forwardResult);
        EasyMock.expect((Object)((RedirectResult)injector.getInstance(RedirectResult.class))).andReturn((Object)redirectResult);
        EasyMock.replay((Object[])new Object[]{injector});
        WorkflowChain workflowChain = (WorkflowChain)EasyMock.createStrictMock(WorkflowChain.class);
        EasyMock.replay((Object[])new Object[]{workflowChain});
        Binder binder = (Binder)EasyMock.createStrictMock(Binder.class);
        EasyMock.expect((Object)binder.bind(RedirectResult.class)).andReturn(null);
        EasyMock.replay((Object[])new Object[]{binder});
        ResultFactory.addResult((Binder)binder, Redirect.class, RedirectResult.class);
        ResultFactory resultFactory = new ResultFactory(injector);
        DefaultResultInvocationWorkflow defaultResultInvocationWorkflow = new DefaultResultInvocationWorkflow(actionInvocationStore, (MVCConfiguration)configuration, Map.of(), resultStore, resourceLocator, resultFactory);
        defaultResultInvocationWorkflow.perform(workflowChain);
        EasyMock.verify((Object[])new Object[]{actionInvocationStore, resultStore, resourceLocator, injector, workflowChain, binder});
    }

    @Test
    public void actionLessWithoutDefault() throws Exception {
        ActionInvocation actionInvocation = new ActionInvocation(null, null, "/foo/bar", null, null);
        ActionInvocationStore actionInvocationStore = (ActionInvocationStore)EasyMock.createStrictMock(ActionInvocationStore.class);
        EasyMock.expect((Object)actionInvocationStore.getCurrent()).andReturn((Object)actionInvocation);
        EasyMock.replay((Object[])new Object[]{actionInvocationStore});
        ResultStore resultStore = (ResultStore)EasyMock.createStrictMock(ResultStore.class);
        EasyMock.replay((Object[])new Object[]{resultStore});
        ResourceLocator resourceLocator = (ResourceLocator)EasyMock.createStrictMock(ResourceLocator.class);
        EasyMock.expect((Object)resourceLocator.locateIndex(DefaultResultInvocationWorkflowTest.configuration.templateDirectory)).andReturn(null);
        EasyMock.replay((Object[])new Object[]{resourceLocator});
        ForwardResult forwardResult = (ForwardResult)EasyMock.createStrictMock(ForwardResult.class);
        EasyMock.expect((Object)forwardResult.execute((Annotation)((Forward)EasyMock.isA(Forward.class)))).andReturn((Object)false);
        EasyMock.replay((Object[])new Object[]{forwardResult});
        Injector injector = (Injector)EasyMock.createStrictMock(Injector.class);
        EasyMock.expect((Object)((ForwardResult)injector.getInstance(ForwardResult.class))).andReturn((Object)forwardResult);
        EasyMock.replay((Object[])new Object[]{injector});
        WorkflowChain workflowChain = (WorkflowChain)EasyMock.createStrictMock(WorkflowChain.class);
        workflowChain.continueWorkflow();
        EasyMock.replay((Object[])new Object[]{workflowChain});
        Binder binder = (Binder)EasyMock.createStrictMock(Binder.class);
        EasyMock.expect((Object)binder.bind(ForwardResult.class)).andReturn(null);
        EasyMock.replay((Object[])new Object[]{binder});
        ResultFactory.addResult((Binder)binder, Forward.class, ForwardResult.class);
        ResultFactory resultFactory = new ResultFactory(injector);
        DefaultResultInvocationWorkflow defaultResultInvocationWorkflow = new DefaultResultInvocationWorkflow(actionInvocationStore, (MVCConfiguration)configuration, Map.of(), resultStore, resourceLocator, resultFactory);
        defaultResultInvocationWorkflow.perform(workflowChain);
        EasyMock.verify((Object[])new Object[]{actionInvocationStore, resultStore, resourceLocator, injector, workflowChain, binder});
    }

    @Test
    public void actionMissingResult() throws Exception {
        ForwardResult.ForwardImpl forwardImpl = new ForwardResult.ForwardImpl("/user/edit", "success");
        ActionInvocation actionInvocation = this.makeActionInvocation(new EditAction(), (Annotation)forwardImpl);
        ActionInvocationStore actionInvocationStore = (ActionInvocationStore)EasyMock.createStrictMock(ActionInvocationStore.class);
        EasyMock.expect((Object)actionInvocationStore.getCurrent()).andReturn((Object)actionInvocation);
        EasyMock.replay((Object[])new Object[]{actionInvocationStore});
        WorkflowChain workflowChain = (WorkflowChain)EasyMock.createStrictMock(WorkflowChain.class);
        EasyMock.replay((Object[])new Object[]{workflowChain});
        ResultStore resultStore = (ResultStore)EasyMock.createStrictMock(ResultStore.class);
        EasyMock.expect((Object)resultStore.get()).andReturn((Object)"failure");
        EasyMock.replay((Object[])new Object[]{resultStore});
        ResourceLocator resourceLocator = (ResourceLocator)EasyMock.createStrictMock(ResourceLocator.class);
        EasyMock.replay((Object[])new Object[]{resourceLocator});
        ForwardResult forwardResult = (ForwardResult)EasyMock.createStrictMock(ForwardResult.class);
        EasyMock.expect((Object)forwardResult.execute((Annotation)((Forward)EasyMock.isA(Forward.class)))).andReturn((Object)true);
        EasyMock.replay((Object[])new Object[]{forwardResult});
        Injector injector = (Injector)EasyMock.createStrictMock(Injector.class);
        EasyMock.expect((Object)((ForwardResult)injector.getInstance(ForwardResult.class))).andReturn((Object)forwardResult);
        EasyMock.replay((Object[])new Object[]{injector});
        Binder binder = (Binder)EasyMock.createStrictMock(Binder.class);
        EasyMock.expect((Object)binder.bind(ForwardResult.class)).andReturn(null);
        EasyMock.replay((Object[])new Object[]{binder});
        ResultFactory.addResult((Binder)binder, Forward.class, ForwardResult.class);
        ResultFactory resultFactory = new ResultFactory(injector);
        DefaultResultInvocationWorkflow defaultResultInvocationWorkflow = new DefaultResultInvocationWorkflow(actionInvocationStore, (MVCConfiguration)configuration, Map.of(), resultStore, resourceLocator, resultFactory);
        try {
            defaultResultInvocationWorkflow.perform(workflowChain);
        }
        catch (PrimeException primeException) {
            Assert.fail((String)"Should not have thrown a PrimeException");
        }
        EasyMock.verify((Object[])new Object[]{actionInvocationStore, resultStore, resourceLocator, injector, workflowChain, binder});
    }

    @Test
    public void actionSuppressResult() throws Exception {
        ActionInvocation actionInvocation = new ActionInvocation(null, null, null, null, null, null, false);
        ActionInvocationStore actionInvocationStore = (ActionInvocationStore)EasyMock.createStrictMock(ActionInvocationStore.class);
        EasyMock.expect((Object)actionInvocationStore.getCurrent()).andReturn((Object)actionInvocation);
        EasyMock.replay((Object[])new Object[]{actionInvocationStore});
        WorkflowChain workflowChain = (WorkflowChain)EasyMock.createStrictMock(WorkflowChain.class);
        EasyMock.replay((Object[])new Object[]{workflowChain});
        ResultStore resultStore = (ResultStore)EasyMock.createStrictMock(ResultStore.class);
        EasyMock.replay((Object[])new Object[]{resultStore});
        ResourceLocator resourceLocator = (ResourceLocator)EasyMock.createStrictMock(ResourceLocator.class);
        EasyMock.replay((Object[])new Object[]{resourceLocator});
        Injector injector = (Injector)EasyMock.createStrictMock(Injector.class);
        EasyMock.replay((Object[])new Object[]{injector});
        Binder binder = (Binder)EasyMock.createStrictMock(Binder.class);
        EasyMock.expect((Object)binder.bind(ForwardResult.class)).andReturn(null);
        EasyMock.replay((Object[])new Object[]{binder});
        ResultFactory.addResult((Binder)binder, Forward.class, ForwardResult.class);
        ResultFactory resultFactory = new ResultFactory(injector);
        DefaultResultInvocationWorkflow defaultResultInvocationWorkflow = new DefaultResultInvocationWorkflow(actionInvocationStore, (MVCConfiguration)configuration, Map.of(), resultStore, resourceLocator, resultFactory);
        defaultResultInvocationWorkflow.perform(workflowChain);
        EasyMock.verify((Object[])new Object[]{actionInvocationStore, resultStore, resourceLocator, injector, workflowChain, binder});
    }

    @Test
    public void actionWithResult() throws Exception {
        ForwardResult.ForwardImpl forwardImpl = new ForwardResult.ForwardImpl("/user/edit", "success");
        ActionInvocation actionInvocation = this.makeActionInvocation(new EditAction(), (Annotation)forwardImpl);
        ActionInvocationStore actionInvocationStore = (ActionInvocationStore)EasyMock.createStrictMock(ActionInvocationStore.class);
        EasyMock.expect((Object)actionInvocationStore.getCurrent()).andReturn((Object)actionInvocation);
        EasyMock.replay((Object[])new Object[]{actionInvocationStore});
        WorkflowChain workflowChain = (WorkflowChain)EasyMock.createStrictMock(WorkflowChain.class);
        EasyMock.replay((Object[])new Object[]{workflowChain});
        ResultStore resultStore = (ResultStore)EasyMock.createStrictMock(ResultStore.class);
        EasyMock.expect((Object)resultStore.get()).andReturn((Object)"success");
        EasyMock.replay((Object[])new Object[]{resultStore});
        ResourceLocator resourceLocator = (ResourceLocator)EasyMock.createStrictMock(ResourceLocator.class);
        EasyMock.replay((Object[])new Object[]{resourceLocator});
        ForwardResult forwardResult = (ForwardResult)EasyMock.createStrictMock(ForwardResult.class);
        EasyMock.expect((Object)forwardResult.execute((Annotation)forwardImpl)).andReturn((Object)true);
        EasyMock.replay((Object[])new Object[]{forwardResult});
        Injector injector = (Injector)EasyMock.createStrictMock(Injector.class);
        EasyMock.expect((Object)((ForwardResult)injector.getInstance(ForwardResult.class))).andReturn((Object)forwardResult);
        EasyMock.replay((Object[])new Object[]{injector});
        Binder binder = (Binder)EasyMock.createStrictMock(Binder.class);
        EasyMock.expect((Object)binder.bind(ForwardResult.class)).andReturn(null);
        EasyMock.replay((Object[])new Object[]{binder});
        ResultFactory.addResult((Binder)binder, Forward.class, ForwardResult.class);
        ResultFactory resultFactory = new ResultFactory(injector);
        DefaultResultInvocationWorkflow defaultResultInvocationWorkflow = new DefaultResultInvocationWorkflow(actionInvocationStore, (MVCConfiguration)configuration, Map.of(), resultStore, resourceLocator, resultFactory);
        defaultResultInvocationWorkflow.perform(workflowChain);
        EasyMock.verify((Object[])new Object[]{actionInvocationStore, resultStore, resourceLocator, injector, workflowChain, binder});
    }

    protected ActionInvocation makeActionInvocation(Object object, Annotation annotation) throws Exception {
        Method method = object.getClass().getMethod("post", new Class[0]);
        ExecuteMethodConfiguration executeMethodConfiguration = new ExecuteMethodConfiguration(HTTPMethod.POST, method, method.getAnnotation(Validation.class));
        HashMap<HTTPMethod, ExecuteMethodConfiguration> hashMap = new HashMap<HTTPMethod, ExecuteMethodConfiguration>();
        hashMap.put(HTTPMethod.POST, executeMethodConfiguration);
        HashMap hashMap2 = new HashMap();
        HashMap<String, Annotation> hashMap3 = new HashMap<String, Annotation>();
        hashMap3.put("success", annotation);
        return new ActionInvocation(object, executeMethodConfiguration, "/user/edit", "", new ActionConfiguration(EditAction.class, false, null, hashMap, hashMap2, new ArrayList(), null, null, new ArrayList(), new HashMap(), new ArrayList(), hashMap3, new HashMap(), null, new HashMap(), new HashSet(), Collections.emptyList(), new ArrayList(), new HashMap(), "/user/edit", new ArrayList(), null, null, null));
    }
}

