/*
 * Decompiled with CFR 0.152.
 */
package org.primeframework.mvc.parameter.convert.converters;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Locale;
import org.apache.commons.lang3.ArrayUtils;
import org.primeframework.mvc.parameter.convert.converters.LocaleConverter;
import org.testng.Assert;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class LocaleConverterTest {
    @Test(dataProvider="localeData")
    public void allLocalesFromBCP47Strings(Locale locale) {
        LocaleConverter localeConverter = new LocaleConverter();
        Locale locale2 = (Locale)localeConverter.convertFromStrings(Locale.class, null, "testExpr", (String[])ArrayUtils.toArray((Object[])new String[]{locale.toLanguageTag()}));
        Assert.assertEquals((String)locale.getLanguage(), (String)locale2.getLanguage());
        Assert.assertEquals((String)locale.getCountry(), (String)locale2.getCountry());
        Assert.assertEquals((String)locale.getVariant(), (String)locale2.getVariant());
    }

    @Test(dataProvider="localeData")
    public void allLocalesFromStrings(Locale locale) {
        LocaleConverter localeConverter = new LocaleConverter();
        Locale locale2 = (Locale)localeConverter.convertFromStrings(Locale.class, null, "testExpr", (String[])ArrayUtils.toArray((Object[])new String[]{locale.toString()}));
        Assert.assertEquals((String)locale.getLanguage(), (String)locale2.getLanguage());
        Assert.assertEquals((String)locale.getCountry(), (String)locale2.getCountry());
        Assert.assertEquals((String)locale.getVariant(), (String)locale2.getVariant());
    }

    @Test
    public void fromStrings() {
        LocaleConverter localeConverter = new LocaleConverter();
        Locale locale = (Locale)localeConverter.convertFromStrings(Locale.class, null, "testExpr", (String[])ArrayUtils.toArray((Object[])new String[]{null}));
        Assert.assertNull((Object)locale);
        locale = (Locale)localeConverter.convertFromStrings(Locale.class, null, "testExpr", (String[])ArrayUtils.toArray((Object[])new String[]{""}));
        Assert.assertEquals((String)locale.getLanguage(), (String)"");
        locale = (Locale)localeConverter.convertFromStrings(Locale.class, null, "testExpr", (String[])ArrayUtils.toArray((Object[])new String[]{"en"}));
        Assert.assertEquals((String)locale.getLanguage(), (String)"en");
        locale = (Locale)localeConverter.convertFromStrings(Locale.class, null, "testExpr", (String[])ArrayUtils.toArray((Object[])new String[]{"en_US"}));
        Assert.assertEquals((String)locale.getLanguage(), (String)"en");
        Assert.assertEquals((String)locale.getCountry(), (String)"US");
        locale = (Locale)localeConverter.convertFromStrings(Locale.class, null, "testExpr", (String[])ArrayUtils.toArray((Object[])new String[]{"en", "US"}));
        Assert.assertEquals((String)locale.getLanguage(), (String)"en");
        Assert.assertEquals((String)locale.getCountry(), (String)"US");
        locale = (Locale)localeConverter.convertFromStrings(Locale.class, null, "testExpr", (String[])ArrayUtils.toArray((Object[])new String[]{"en_US_UTF8"}));
        Assert.assertEquals((String)locale.getLanguage(), (String)"en");
        Assert.assertEquals((String)locale.getCountry(), (String)"US");
        Assert.assertEquals((String)locale.getVariant(), (String)"UTF8");
        locale = (Locale)localeConverter.convertFromStrings(Locale.class, null, "testExpr", (String[])ArrayUtils.toArray((Object[])new String[]{"en", "US", "UTF8"}));
        Assert.assertEquals((String)locale.getLanguage(), (String)"en");
        Assert.assertEquals((String)locale.getCountry(), (String)"US");
        Assert.assertEquals((String)locale.getVariant(), (String)"UTF8");
        locale = (Locale)localeConverter.convertFromStrings(Locale.class, null, "testExpr", (String[])ArrayUtils.toArray((Object[])new String[]{"es", "419", "UTF8"}));
        Assert.assertEquals((String)locale.getLanguage(), (String)"es");
        Assert.assertEquals((String)locale.getCountry(), (String)"419");
        Assert.assertEquals((String)locale.getVariant(), (String)"UTF8");
        locale = (Locale)localeConverter.convertFromStrings(Locale.class, null, "testExpr", (String[])ArrayUtils.toArray((Object[])new String[]{"es", "AR", "UTF8"}));
        Assert.assertEquals((String)locale.getLanguage(), (String)"es");
        Assert.assertEquals((String)locale.getCountry(), (String)"AR");
        Assert.assertEquals((String)locale.getVariant(), (String)"UTF8");
    }

    @DataProvider(name="localeData")
    public Object[] localeData() {
        ArrayList<Locale> arrayList = new ArrayList<Locale>();
        Collections.addAll(arrayList, Locale.getAvailableLocales());
        arrayList.removeIf(locale -> locale.getLanguage().isEmpty() || locale.hasExtensions() || !locale.getScript().isEmpty() || locale.toString().equals("no_NO_NY"));
        return arrayList.toArray();
    }

    @Test
    public void toStrings() {
        LocaleConverter localeConverter = new LocaleConverter();
        String string = localeConverter.convertToString(Locale.class, null, "testExpr", null);
        Assert.assertNull((Object)string);
        string = localeConverter.convertToString(Locale.class, null, "testExpr", (Object)Locale.US);
        Assert.assertEquals((String)string, (String)"en_US");
    }
}

