/*
 * Decompiled with CFR 0.152.
 */
package org.primeframework.mvc;

import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import org.example.action.PostAction;
import org.primeframework.mvc.PrimeBaseTest;
import org.testng.Assert;
import org.testng.annotations.Test;

public class PrimeHTTPServerTest
extends PrimeBaseTest {
    @Test(enabled=false)
    public void load() {
        long l = System.currentTimeMillis();
        HttpClient httpClient = HttpClient.newBuilder().followRedirects(HttpClient.Redirect.NEVER).priority(256).build();
        for (int i = 0; i < 100000; ++i) {
            HttpRequest httpRequest = HttpRequest.newBuilder(URI.create("http://localhost:" + simulator.getPort() + "/post")).POST(HttpRequest.BodyPublishers.noBody()).build();
            HttpResponse<String> httpResponse = null;
            try {
                httpResponse = httpClient.send(httpRequest, HttpResponse.BodyHandlers.ofString());
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
            Assert.assertEquals((int)httpResponse.statusCode(), (int)200);
            Assert.assertTrue((boolean)httpResponse.body().contains("Brian Pontarelli"));
        }
        long l2 = System.currentTimeMillis();
        System.out.println("100,000 took [" + (l2 - l) + "]");
    }

    @Test
    public void post() throws Exception {
        PostAction.invoked = false;
        HttpResponse httpResponse = HttpClient.newHttpClient().send(HttpRequest.newBuilder().uri(URI.create("http://localhost:" + PrimeHTTPServerTest.simulator.port + "/post")).POST(HttpRequest.BodyPublishers.noBody()).build(), responseInfo -> HttpResponse.BodySubscribers.ofString(StandardCharsets.UTF_8));
        Assert.assertEquals((int)httpResponse.statusCode(), (int)200);
        Assert.assertTrue((boolean)((String)httpResponse.body()).contains("Brian Pontarelli"));
        Assert.assertTrue((boolean)PostAction.invoked);
    }

    @Test(enabled=false)
    public void threads() throws Exception {
        int n;
        long l = System.currentTimeMillis();
        HttpClient httpClient = HttpClient.newBuilder().followRedirects(HttpClient.Redirect.NEVER).priority(256).build();
        ArrayList<Thread> arrayList = new ArrayList<Thread>();
        for (n = 0; n < 10; ++n) {
            String string = "Thread " + n;
            Thread thread = new Thread(() -> {
                for (int i = 0; i < 10000; ++i) {
                    HttpRequest httpRequest = HttpRequest.newBuilder(URI.create("http://localhost:" + simulator.getPort() + "/echo?message=" + string)).GET().build();
                    HttpResponse<String> httpResponse = null;
                    try {
                        httpResponse = httpClient.send(httpRequest, HttpResponse.BodyHandlers.ofString());
                    }
                    catch (Exception exception) {
                        throw new RuntimeException(exception);
                    }
                    Assert.assertEquals((int)httpResponse.statusCode(), (int)200);
                    Assert.assertTrue((boolean)httpResponse.body().contains(string));
                }
            }, string);
            arrayList.add(thread);
            thread.start();
        }
        for (n = 0; n < 10; ++n) {
            ((Thread)arrayList.get(n)).join();
        }
        long l2 = System.currentTimeMillis();
        System.out.println("100,000 threaded took [" + (l2 - l) + "]");
    }
}

