/*
 * Decompiled with CFR 0.152.
 */
package org.primeframework.mvc;

import com.codahale.metrics.MetricRegistry;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.inject.AbstractModule;
import com.google.inject.Binder;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Singleton;
import com.google.inject.name.Names;
import com.google.inject.util.Modules;
import io.fusionauth.http.HTTPMethod;
import io.fusionauth.http.log.AccumulatingLoggerFactory;
import io.fusionauth.http.log.BaseLogger;
import io.fusionauth.http.log.Level;
import io.fusionauth.http.log.Logger;
import io.fusionauth.http.log.LoggerFactory;
import io.fusionauth.http.server.HTTPContext;
import io.fusionauth.http.server.HTTPListenerConfiguration;
import io.fusionauth.http.server.HTTPRequest;
import io.fusionauth.http.server.HTTPResponse;
import io.fusionauth.http.server.HTTPServerConfiguration;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.example.action.SecureAction;
import org.example.action.oauth.TokenAction;
import org.example.action.user.EditAction;
import org.primeframework.mvc.MockConfiguration;
import org.primeframework.mvc.MockMVCWorkflowFinalizer;
import org.primeframework.mvc.TestBuilder;
import org.primeframework.mvc.TestPrimeMain;
import org.primeframework.mvc.action.ActionInvocation;
import org.primeframework.mvc.action.ExecuteMethodConfiguration;
import org.primeframework.mvc.action.config.ActionConfiguration;
import org.primeframework.mvc.action.config.DefaultActionConfigurationBuilder;
import org.primeframework.mvc.action.result.MVCWorkflowFinalizer;
import org.primeframework.mvc.action.result.ResultStore;
import org.primeframework.mvc.config.MVCConfiguration;
import org.primeframework.mvc.content.guice.ContentHandlerFactory;
import org.primeframework.mvc.content.guice.ObjectMapperProvider;
import org.primeframework.mvc.content.json.JacksonContentHandler;
import org.primeframework.mvc.cors.CORSConfiguration;
import org.primeframework.mvc.cors.CORSConfigurationProvider;
import org.primeframework.mvc.guice.MVCModule;
import org.primeframework.mvc.http.HTTPObjectsHolder;
import org.primeframework.mvc.jwt.MockVerifierProvider;
import org.primeframework.mvc.message.MessageObserver;
import org.primeframework.mvc.message.TestMessageObserver;
import org.primeframework.mvc.message.scope.ApplicationScope;
import org.primeframework.mvc.message.scope.CookieFlashScope;
import org.primeframework.mvc.message.scope.FlashScope;
import org.primeframework.mvc.message.scope.RequestScope;
import org.primeframework.mvc.security.CBCCipherProvider;
import org.primeframework.mvc.security.CipherProvider;
import org.primeframework.mvc.security.GCMCipherProvider;
import org.primeframework.mvc.security.JWTSecurityScheme;
import org.primeframework.mvc.security.MockOAuthUserLoginSecurityContext;
import org.primeframework.mvc.security.MockStaticClasspathResourceFilter;
import org.primeframework.mvc.security.MockStaticResourceFilter;
import org.primeframework.mvc.security.MockUserLoginSecurityContext;
import org.primeframework.mvc.security.StaticClasspathResourceFilter;
import org.primeframework.mvc.security.StaticResourceFilter;
import org.primeframework.mvc.security.UserLoginSecurityContext;
import org.primeframework.mvc.security.VerifierProvider;
import org.primeframework.mvc.security.csrf.CSRFProvider;
import org.primeframework.mvc.security.guice.SecuritySchemeFactory;
import org.primeframework.mvc.test.RequestBuilder;
import org.primeframework.mvc.test.RequestSimulator;
import org.primeframework.mvc.util.ThrowingRunnable;
import org.primeframework.mvc.validation.Validation;
import org.primeframework.mvc.workflow.TypedExceptionHandler;
import org.primeframework.mvc.workflow.TypedExceptionHandlerFactory;
import org.primeframework.mvc.workflow.guice.WorkflowModule;
import org.testng.Assert;
import org.testng.ITestListener;
import org.testng.ITestResult;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.AfterSuite;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.BeforeSuite;
import org.testng.annotations.DataProvider;

public abstract class PrimeBaseTest {
    protected static final TestMessageObserver messageObserver = new TestMessageObserver();
    public static MockConfiguration configuration = new MockConfiguration();
    public static HTTPContext context;
    public static CORSConfiguration corsConfiguration;
    public static Injector injector;
    public static MetricRegistry metricRegistry;
    public static RequestSimulator simulator;
    @Inject
    public CSRFProvider csrfProvider;
    @Inject
    public ObjectMapper objectMapper;
    public HTTPRequest request;
    public HTTPResponse response;
    @Inject
    public TestBuilder test;

    public static void expectException(Class<? extends Throwable> clazz, ThrowingRunnable throwingRunnable, String string) {
        try {
            throwingRunnable.run();
        }
        catch (Throwable throwable) {
            int n = 0;
            for (Throwable throwable2 = throwable; n < 4 && throwable2 != null; ++n, throwable2 = throwable2.getCause()) {
                if (!throwable2.getClass().isAssignableFrom(clazz)) continue;
                if (string != null) {
                    Assert.assertEquals((String)throwable2.getMessage(), (String)string);
                }
                return;
            }
            Assert.fail((String)("Expected [" + clazz.getName() + "], but caught [" + throwable.getClass().getName() + "] Message [" + (throwable.getMessage() != null ? throwable.getMessage() : "-") + "]"));
            return;
        }
        Assert.fail((String)("Expected [" + clazz.getName() + "], but no exception was thrown."));
    }

    public static void expectException(Class<? extends Throwable> clazz, ThrowingRunnable throwingRunnable) {
        PrimeBaseTest.expectException(clazz, throwingRunnable, null);
    }

    @AfterMethod
    public void afterMethod() {
        HTTPObjectsHolder.clearRequest();
        HTTPObjectsHolder.clearResponse();
    }

    @BeforeMethod
    public void beforeMethod() {
        this.request = new HTTPRequest();
        this.response = new HTTPResponse();
        HTTPObjectsHolder.setRequest((HTTPRequest)this.request);
        HTTPObjectsHolder.setResponse((HTTPResponse)this.response);
        injector.injectMembers((Object)this);
        this.test.context = context;
        this.test.simulator = simulator;
        this.test.userAgent = PrimeBaseTest.simulator.userAgent;
        TestObjectMapperProvider.test = this.test;
        PrimeBaseTest.simulator.userAgent.reset();
        metricRegistry = (MetricRegistry)injector.getInstance(MetricRegistry.class);
        metricRegistry.getNames().forEach(arg_0 -> ((MetricRegistry)metricRegistry).remove(arg_0));
        messageObserver.reset();
        MockUserLoginSecurityContext.roles.clear();
        MockUserLoginSecurityContext.currentUser = null;
        MockOAuthUserLoginSecurityContext.additionalParameters.clear();
        PrimeBaseTest.configuration.csrfEnabled = false;
        PrimeBaseTest.configuration.allowUnknownParameters = false;
        MockMVCWorkflowFinalizer.Called.set(0);
        ((TestAccumulatingLogger)TestAccumulatingLoggerFactory.FACTORY.getLogger(PrimeBaseTest.class)).reset();
        TestAccumulatingLoggerFactory.FACTORY.getLogger(PrimeBaseTest.class).setLevel(Level.Trace);
        EditAction.getCalled = false;
        SecureAction.UnknownParameters.clear();
        TokenAction.UnknownParameters.clear();
        TestUnhandledExceptionHandler.reset();
        MockStaticClasspathResourceFilter.TestFunction = null;
    }

    @BeforeSuite
    public void init() {
        MVCModule mVCModule = new MVCModule(this){

            protected void configure() {
                super.configure();
                this.install((Module)new TestMVCConfigurationModule());
                this.bind(CORSConfigurationProvider.class).to(TestCORSConfigurationProvider.class).in(Singleton.class);
                this.bind(RequestBuilder.HTTPRequestConsumer.class).to(TestHTTPRequestConsumer.class);
                this.bind(MessageObserver.class).toInstance((Object)messageObserver);
                this.bind(MetricRegistry.class).toInstance((Object)metricRegistry);
                this.bind(UserLoginSecurityContext.class).to(MockUserLoginSecurityContext.class);
                SecuritySchemeFactory.addSecurityScheme((Binder)this.binder(), (String)"jwt-other", JWTSecurityScheme.class);
                ContentHandlerFactory.addContentHandler((Binder)this.binder(), (String)"application/test+json", JacksonContentHandler.class);
            }
        };
        Module module = Modules.override((Module[])new Module[]{mVCModule}).with(new Module[]{new TestContentModule(), new TestSecurityModule(), new TestScopeModule(), new TestWorkflowModule(), new TestStaticResourceModule()});
        HTTPServerConfiguration hTTPServerConfiguration = new HTTPServerConfiguration().withInitialReadTimeout(Duration.ofMinutes(10L)).withMinimumReadThroughput(-1L).withMinimumWriteThroughput(-1L).withProcessingTimeoutDuration(Duration.ofMinutes(10L)).withListener(new HTTPListenerConfiguration(9080)).withLoggerFactory((LoggerFactory)TestAccumulatingLoggerFactory.FACTORY);
        TestPrimeMain testPrimeMain = new TestPrimeMain(new HTTPServerConfiguration[]{hTTPServerConfiguration}, module);
        simulator = new RequestSimulator(testPrimeMain, messageObserver);
        injector = simulator.getInjector();
        context = (HTTPContext)injector.getInstance(HTTPContext.class);
    }

    @DataProvider(name="methodOverrides")
    public Object[][] methodOverrides() {
        return new Object[][]{{"X-HTTP-Method-Override"}, {"x-http-method-override"}, {"X-Method-Override"}, {"x-method-override"}};
    }

    @AfterSuite
    public void shutdown() {
        simulator.shutdown();
    }

    protected ActionInvocation makeActionInvocation(Object object, HTTPMethod hTTPMethod, String string, Map<String, List<String>> map) {
        DefaultActionConfigurationBuilder defaultActionConfigurationBuilder = (DefaultActionConfigurationBuilder)injector.getInstance(DefaultActionConfigurationBuilder.class);
        ActionConfiguration actionConfiguration = defaultActionConfigurationBuilder.build(object.getClass());
        return new ActionInvocation(object, (ExecuteMethodConfiguration)actionConfiguration.executeMethods.get(hTTPMethod), actionConfiguration.uri, string, map, actionConfiguration, true);
    }

    protected ActionInvocation makeActionInvocation(HTTPMethod hTTPMethod, Object object, String string, String string2, String string3, String string4, Annotation annotation) throws Exception {
        Method method = object.getClass().getMethod(string, new Class[0]);
        ExecuteMethodConfiguration executeMethodConfiguration = new ExecuteMethodConfiguration(hTTPMethod, method, method.getAnnotation(Validation.class));
        HashMap<HTTPMethod, ExecuteMethodConfiguration> hashMap = new HashMap<HTTPMethod, ExecuteMethodConfiguration>();
        hashMap.put(hTTPMethod, executeMethodConfiguration);
        HashMap hashMap2 = new HashMap();
        HashMap<String, Annotation> hashMap3 = new HashMap<String, Annotation>();
        hashMap3.put(string4, annotation);
        return new ActionInvocation(object, executeMethodConfiguration, string2, string3, new ActionConfiguration(EditAction.class, false, null, hashMap, hashMap2, new ArrayList(), null, null, new ArrayList(), new HashMap(), new ArrayList(), hashMap3, new HashMap(), null, new HashMap(), new HashSet(), Collections.emptyList(), new ArrayList(), new HashMap(), string2, new ArrayList(), null, null, null));
    }

    protected ActionInvocation makeActionInvocation(Object object, HTTPMethod hTTPMethod, String string) {
        DefaultActionConfigurationBuilder defaultActionConfigurationBuilder = (DefaultActionConfigurationBuilder)injector.getInstance(DefaultActionConfigurationBuilder.class);
        ActionConfiguration actionConfiguration = defaultActionConfigurationBuilder.build(object.getClass());
        return new ActionInvocation(object, (ExecuteMethodConfiguration)actionConfiguration.executeMethods.get(hTTPMethod), actionConfiguration.uri, string, actionConfiguration);
    }

    protected Map<String, List<String>> map(Object ... objectArray) {
        HashMap<String, List<String>> hashMap = new HashMap<String, List<String>>();
        for (int i = 0; i < objectArray.length; i += 2) {
            hashMap.put(objectArray[i].toString(), (List)objectArray[i + 1]);
        }
        return hashMap;
    }

    static {
        metricRegistry = new MetricRegistry();
    }

    public static class TestObjectMapperProvider
    extends ObjectMapperProvider {
        public static TestBuilder test;

        @Inject
        public TestObjectMapperProvider(Set<com.fasterxml.jackson.databind.Module> set, MVCConfiguration mVCConfiguration) {
            super(set, mVCConfiguration);
        }

        public ObjectMapper get() {
            ObjectMapper objectMapper = super.get();
            if (test != null && TestObjectMapperProvider.test.objectMapperFunction != null) {
                return TestObjectMapperProvider.test.objectMapperFunction.apply(objectMapper);
            }
            return objectMapper;
        }
    }

    static class TestAccumulatingLoggerFactory
    extends AccumulatingLoggerFactory {
        public static final TestAccumulatingLoggerFactory FACTORY = new TestAccumulatingLoggerFactory();
        private static final Logger logger = new TestAccumulatingLogger();

        TestAccumulatingLoggerFactory() {
        }

        public Logger getLogger(Class<?> clazz) {
            return logger;
        }
    }

    static class TestAccumulatingLogger
    extends BaseLogger {
        private final LinkedList<String> messages = new LinkedList();

        TestAccumulatingLogger() {
        }

        public void reset() {
            this.messages.clear();
        }

        public String toString() {
            try {
                return "\n     | " + String.join((CharSequence)"\n     | ", this.messages);
            }
            catch (Exception exception) {
                Object object = "\nFailed to call toString()";
                object = (String)object + " size [" + this.messages.size() + "]";
                PrintWriter printWriter = new PrintWriter(new StringWriter());
                exception.printStackTrace(printWriter);
                object = (String)object + "\n" + String.valueOf(printWriter) + "\n\n";
                return object;
            }
        }

        protected void handleMessage(String string) {
            while (this.messages.size() > 100000) {
                this.messages.removeFirst();
            }
            this.messages.add(string);
        }
    }

    static class TestUnhandledExceptionHandler
    implements TypedExceptionHandler<Exception> {
        public static Exception exception;
        private final ResultStore resultStore;

        @Inject
        TestUnhandledExceptionHandler(ResultStore resultStore) {
            this.resultStore = resultStore;
        }

        public static void assertLastUnhandledException(Exception exception) {
            Assert.assertEquals(TestUnhandledExceptionHandler.exception.getClass(), exception.getClass());
            Assert.assertEquals((String)TestUnhandledExceptionHandler.exception.getMessage(), (String)exception.getMessage());
            TestUnhandledExceptionHandler.reset();
        }

        public static void assertNoUnhandledException() {
            Assert.assertNull((Object)exception);
        }

        public static void reset() {
            exception = null;
        }

        public void handle(Exception exception) {
            this.resultStore.set("error");
            TestUnhandledExceptionHandler.exception = exception;
            exception.printStackTrace();
        }
    }

    public static class TestContentModule
    extends AbstractModule {
        protected void configure() {
            this.bind(ObjectMapper.class).toProvider(TestObjectMapperProvider.class);
        }
    }

    public static class TestSecurityModule
    extends AbstractModule {
        protected void configure() {
            this.bind(CipherProvider.class).annotatedWith((Annotation)Names.named((String)"CBC")).to(CBCCipherProvider.class);
            this.bind(CipherProvider.class).annotatedWith((Annotation)Names.named((String)"GCM")).to(GCMCipherProvider.class);
            this.bind(VerifierProvider.class).to(MockVerifierProvider.class);
        }
    }

    public static class TestScopeModule
    extends AbstractModule {
        protected void configure() {
            this.bind(ApplicationScope.class).asEagerSingleton();
            this.bind(RequestScope.class);
            this.bind(FlashScope.class).toProvider(() -> (FlashScope)injector.getInstance(CookieFlashScope.class));
        }
    }

    public static class TestWorkflowModule
    extends WorkflowModule {
        protected void bindMVCWorkflowFinalizer() {
            this.bind(MVCWorkflowFinalizer.class).to(MockMVCWorkflowFinalizer.class);
        }

        protected void configure() {
            super.configure();
            TypedExceptionHandlerFactory.addExceptionHandler((Binder)this.binder(), Exception.class, TestUnhandledExceptionHandler.class);
        }
    }

    public static class TestStaticResourceModule
    extends AbstractModule {
        protected void configure() {
            this.bind(StaticResourceFilter.class).to(MockStaticResourceFilter.class);
            this.bind(StaticClasspathResourceFilter.class).to(MockStaticClasspathResourceFilter.class);
        }
    }

    public static class TestMVCConfigurationModule
    extends AbstractModule {
        protected void configure() {
            this.bind(MVCConfiguration.class).toInstance((Object)configuration);
        }
    }

    public static class TestListener
    implements ITestListener {
        private static final AtomicInteger TestCounter = new AtomicInteger(0);
        private String lastTestMethod;
        private int lastTestMethodCounter = 0;

        public void onTestFailure(ITestResult iTestResult) {
            Throwable throwable = iTestResult.getThrowable();
            String string = TestAccumulatingLoggerFactory.FACTORY.getLogger(PrimeBaseTest.class).toString();
            System.out.println("\n\n\nTest failure\n-----------------\nException: {{exception}}\nMessage: {{message}}\n\nHTTP Trace:\n{{trace}}\n-----------------\n".replace("{{exception}}", throwable != null ? throwable.getClass().getSimpleName() : "-").replace("{{message}}", throwable != null ? (throwable.getMessage() != null ? throwable.getMessage() : "-") : "-").replace("{{trace}}", string.equals("") ? "[-]" : string));
        }

        public void onTestStart(ITestResult iTestResult) {
            Object[] objectArray = iTestResult.getParameters();
            Object object = objectArray != null && objectArray.length > 0 ? " [" + this.serializeDataProviderArgs(objectArray) + "]" : "";
            String string = iTestResult.getTestClass().getName() + "." + iTestResult.getName();
            if (this.lastTestMethod != null && !this.lastTestMethod.equals(string)) {
                this.lastTestMethodCounter = 0;
            }
            if (!((String)object).equals("")) {
                object = (String)object + " (" + ++this.lastTestMethodCounter + ")";
            }
            this.lastTestMethod = string;
            System.out.println("[" + TestCounter.incrementAndGet() + "] " + string + (String)object);
        }

        private String serializeDataProviderArgs(Object[] objectArray) {
            Object object2 = Arrays.stream(objectArray).map(object -> (object == null ? "null" : object.toString()).replace("\n", " ")).collect(Collectors.joining(", "));
            int n = 128;
            if (((String)object2).length() > n) {
                if (((String)object2).charAt(n) == ',') {
                    --n;
                }
                object2 = ((String)object2).substring(0, n) + "\u2026";
            }
            return object2;
        }
    }

    public static class TestHTTPRequestConsumer
    implements RequestBuilder.HTTPRequestConsumer {
        @Override
        public void accept(HTTPRequest hTTPRequest) {
            hTTPRequest.setHeader("X-Test-HTTP-Request-Consumer", "true");
        }
    }

    public static class TestCORSConfigurationProvider
    implements CORSConfigurationProvider {
        public CORSConfiguration get() {
            return corsConfiguration;
        }
    }
}

