/*
 * Decompiled with CFR 0.152.
 */
package org.primeframework.mvc;

import com.google.inject.Inject;
import java.util.Base64;
import org.example.action.SecureAction;
import org.example.domain.User;
import org.primeframework.mvc.PrimeBaseTest;
import org.primeframework.mvc.config.MVCConfiguration;
import org.primeframework.mvc.security.CBCCipherProvider;
import org.primeframework.mvc.security.CipherProvider;
import org.primeframework.mvc.security.DefaultEncryptor;
import org.primeframework.mvc.security.MockUserLoginSecurityContext;
import org.primeframework.mvc.security.UserLoginSecurityContext;
import org.testng.Assert;
import org.testng.annotations.Test;

public class CSRFTest
extends PrimeBaseTest {
    @Inject
    public UserLoginSecurityContext securityContext;

    @Test
    public void delete_CSRFTokenSuccess() {
        MockUserLoginSecurityContext.roles.add("delete-only");
        this.securityContext.login((Object)new User());
        CSRFTest.configuration.csrfEnabled = true;
        simulator.test("/secure").withSingleHeader("Referer", "http://localhost:" + simulator.getPort() + "/secure").withSingleHeader(this.csrfProvider.getHeaderName(), this.csrfProvider.getToken(this.request)).delete().assertStatusCode(200).assertBody("Secure!");
        simulator.test("/secure").withSingleHeader(this.csrfProvider.getHeaderName(), this.csrfProvider.getToken(this.request)).delete().assertStatusCode(200).assertBody("Secure!");
    }

    @Test
    public void get_CSRFToken() {
        MockUserLoginSecurityContext.roles.add("admin");
        this.securityContext.login((Object)new User());
        CSRFTest.configuration.csrfEnabled = true;
        simulator.test("/secure").get().assertStatusCode(200).assertBody("Secure!");
        Assert.assertFalse((boolean)SecureAction.UnknownParameters.containsKey(this.csrfProvider.getParameterName()));
    }

    @Test
    public void patch_CSRFTokenSuccess() {
        MockUserLoginSecurityContext.roles.add("patch-only");
        this.securityContext.login((Object)new User());
        CSRFTest.configuration.csrfEnabled = true;
        simulator.test("/secure").withSingleHeader("Referer", "http://localhost:" + simulator.getPort() + "/secure").withSingleHeader(this.csrfProvider.getHeaderName(), this.csrfProvider.getToken(this.request)).patch().assertStatusCode(200).assertBody("Secure!");
        simulator.test("/secure").withSingleHeader(this.csrfProvider.getHeaderName(), this.csrfProvider.getToken(this.request)).patch().assertStatusCode(200).assertBody("Secure!");
    }

    @Test
    public void post_CSRFOriginFailure() {
        MockUserLoginSecurityContext.roles.add("admin");
        this.securityContext.login((Object)new User());
        CSRFTest.configuration.csrfEnabled = true;
        simulator.test("/secure").withSingleHeader("Origin", "https://malicious.com").post().assertStatusCode(403);
        simulator.test("/secure").withSingleHeader("Origin", "null").post().assertStatusCode(403);
    }

    @Test
    public void post_CSRFRefererFailure() {
        MockUserLoginSecurityContext.roles.add("admin");
        this.securityContext.login((Object)new User());
        CSRFTest.configuration.csrfEnabled = true;
        simulator.test("/secure").withSingleHeader("Referer", "https://malicious.com").post().assertStatusCode(403);
    }

    @Test
    public void post_CSRFTokenFailure() {
        MockUserLoginSecurityContext.roles.add("admin");
        this.securityContext.login((Object)new User());
        CSRFTest.configuration.csrfEnabled = true;
        simulator.test("/secure").withCSRFToken("bad-token").post().assertStatusCode(403);
    }

    @Test
    public void post_CSRFTokenSuccess() {
        MockUserLoginSecurityContext.roles.add("admin");
        this.securityContext.login((Object)new User());
        CSRFTest.configuration.csrfEnabled = true;
        simulator.test("/secure").withSingleHeader("Referer", "http://localhost:" + simulator.getPort() + "/secure").withCSRFToken(this.csrfProvider.getToken(this.request)).post().assertStatusCode(200).assertBody("Secure!");
        simulator.test("/secure").withCSRFToken(this.csrfProvider.getToken(this.request)).post().assertStatusCode(200).assertBody("Secure!");
        simulator.test("/secure").post().assertStatusCode(200).assertBody("Secure!");
    }

    @Test
    public void post_CSRFTokenCompatibility() throws Exception {
        MockUserLoginSecurityContext.roles.add("admin");
        this.securityContext.login((Object)new User());
        CSRFTest.configuration.csrfEnabled = true;
        CSRFToken cSRFToken = new CSRFToken(this.securityContext.getSessionId(), System.currentTimeMillis());
        byte[] byArray = this.objectMapper.writeValueAsBytes((Object)cSRFToken);
        DefaultEncryptor defaultEncryptor = new DefaultEncryptor((CipherProvider)new CBCCipherProvider((MVCConfiguration)configuration), (CipherProvider)new CBCCipherProvider((MVCConfiguration)configuration));
        byte[] byArray2 = defaultEncryptor.encrypt(byArray);
        String string = Base64.getUrlEncoder().encodeToString(byArray2);
        simulator.test("/secure").withSingleHeader("Referer", "http://localhost:" + simulator.getPort() + "/secure").withCSRFToken(string).post().assertStatusCode(200).assertBody("Secure!");
        Assert.assertTrue((boolean)SecureAction.UnknownParameters.containsKey(this.csrfProvider.getParameterName()));
    }

    @Test
    public void put_CSRFTokenSuccess() {
        MockUserLoginSecurityContext.roles.add("put-only");
        this.securityContext.login((Object)new User());
        CSRFTest.configuration.csrfEnabled = true;
        simulator.test("/secure").withSingleHeader("Referer", "http://localhost:" + simulator.getPort() + "/secure").withSingleHeader(this.csrfProvider.getHeaderName(), this.csrfProvider.getToken(this.request)).put().assertStatusCode(200).assertBody("Secure!");
        simulator.test("/secure").withSingleHeader(this.csrfProvider.getHeaderName(), this.csrfProvider.getToken(this.request)).put().assertStatusCode(200).assertBody("Secure!");
    }

    private record CSRFToken(String sid, long instant) {
    }
}

