/*
 * Decompiled with CFR 0.152.
 */
package org.primeframework.mvc.workflow;

import com.google.inject.Inject;
import io.fusionauth.http.HTTPMethod;
import java.io.IOException;
import java.util.List;
import org.primeframework.mvc.action.ActionInvocation;
import org.primeframework.mvc.action.ActionInvocationStore;
import org.primeframework.mvc.action.ActionInvocationWorkflow;
import org.primeframework.mvc.action.ActionMapper;
import org.primeframework.mvc.action.result.ResultInvocationWorkflow;
import org.primeframework.mvc.config.MVCConfiguration;
import org.primeframework.mvc.scope.ScopeStorageWorkflow;
import org.primeframework.mvc.workflow.MissingWorkflow;
import org.primeframework.mvc.workflow.SubWorkflowChain;
import org.primeframework.mvc.workflow.Workflow;
import org.primeframework.mvc.workflow.WorkflowChain;

public class DefaultMissingWorkflow
implements MissingWorkflow {
    private final ActionInvocationStore actionInvocationStore;
    private final ActionMapper actionMapper;
    private final MVCConfiguration configuration;
    private final List<Workflow> workflows;

    @Inject
    public DefaultMissingWorkflow(ActionInvocationStore actionInvocationStore, ActionMapper actionMapper, MVCConfiguration configuration, ActionInvocationWorkflow actionInvocationWorkflow, ScopeStorageWorkflow scopeStorageWorkflow, ResultInvocationWorkflow resultInvocationWorkflow) {
        this.actionInvocationStore = actionInvocationStore;
        this.actionMapper = actionMapper;
        this.configuration = configuration;
        this.workflows = List.of(actionInvocationWorkflow, scopeStorageWorkflow, resultInvocationWorkflow);
    }

    @Override
    public void perform(WorkflowChain workflowChain) throws IOException {
        ActionInvocation missingInvocation = this.actionMapper.map(HTTPMethod.GET, this.configuration.missingPath());
        this.actionInvocationStore.setCurrent(missingInvocation);
        SubWorkflowChain chain = new SubWorkflowChain(this.workflows, workflowChain);
        chain.continueWorkflow();
    }
}

