/*
 * Decompiled with CFR 0.152.
 */
package org.primeframework.mvc.security;

import io.fusionauth.http.Cookie;
import io.fusionauth.http.server.HTTPRequest;
import io.fusionauth.http.server.HTTPResponse;

public class CookieProxy {
    private final Long maxAge;
    private final String name;
    private final Cookie.SameSite sameSite;

    public CookieProxy(String name, Long maxAge, Cookie.SameSite sameSite) {
        this.name = name;
        this.maxAge = maxAge;
        this.sameSite = sameSite;
    }

    public void add(HTTPRequest request, HTTPResponse response, String value) {
        Cookie cookie = new Cookie(this.name, value);
        cookie.httpOnly = true;
        cookie.maxAge = this.maxAge;
        cookie.path = "/";
        cookie.sameSite = this.sameSite;
        cookie.secure = "https".equalsIgnoreCase(request.getScheme());
        response.addCookie(cookie);
    }

    public void delete(HTTPRequest request, HTTPResponse response) {
        Cookie cookie = new Cookie(this.name, null);
        cookie.maxAge = 0L;
        cookie.path = "/";
        response.addCookie(cookie);
        request.setAttribute(this.name + "Deleted", (Object)true);
    }

    public String get(HTTPRequest request) {
        if (request.getAttribute(this.name + "Deleted") != null) {
            return null;
        }
        Cookie cookie = request.getCookie(this.name);
        return cookie != null ? cookie.value : null;
    }
}

