/*
 * Decompiled with CFR 0.152.
 */
package org.primeframework.mvc.parameter.convert.converters;

import com.google.inject.Inject;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.primeframework.mvc.parameter.convert.AbstractGlobalConverter;
import org.primeframework.mvc.parameter.convert.ConversionException;
import org.primeframework.mvc.parameter.convert.ConverterProvider;
import org.primeframework.mvc.parameter.convert.ConverterStateException;
import org.primeframework.mvc.parameter.convert.GlobalConverter;
import org.primeframework.mvc.parameter.convert.converters.StringConverter;
import org.primeframework.mvc.util.TypeTools;

@org.primeframework.mvc.parameter.convert.annotation.GlobalConverter
public class CollectionConverter
extends AbstractGlobalConverter {
    private final ConverterProvider provider;

    @Inject
    public CollectionConverter(ConverterProvider provider) {
        this.provider = provider;
    }

    protected Collection makeCollection(Class<?> type) {
        if (type == List.class) {
            return new ArrayList();
        }
        if (type == SortedSet.class) {
            return new TreeSet();
        }
        if (type == Set.class) {
            return new HashSet();
        }
        if (type == Queue.class) {
            return new LinkedList();
        }
        try {
            return (Collection)type.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new ConverterStateException("The type [" + String.valueOf(type) + "] is a collection but could not be instantiated by the converter class");
        }
    }

    @Override
    protected String objectToString(Object value, Type convertFrom, Map<String, String> dynamicAttributes, String expression) throws ConversionException, ConverterStateException {
        List<Object> collection = value.getClass().isArray() ? Arrays.asList((Object[])value) : (List<Object>)value;
        String values = collection.stream().filter(Objects::nonNull).map(Object::toString).collect(Collectors.joining(","));
        throw new ConverterStateException("This operation is unsupported. You may not serialize a collection to a string. Expression[" + expression + "], values [" + values + "]");
    }

    @Override
    protected Object stringToObject(String value, Type convertTo, Map<String, String> dynamicAttributes, String expression) throws ConversionException, ConverterStateException {
        return this.stringsToObject(new String[]{value}, convertTo, dynamicAttributes, expression);
    }

    @Override
    protected Object stringsToObject(String[] values, Type convertTo, Map<String, String> dynamicAttributes, String expression) throws ConversionException, ConverterStateException {
        Class<?> rawType = TypeTools.rawType(convertTo);
        Class<?> parameter = this.parameterType(convertTo);
        Collection collection = this.makeCollection(rawType);
        if (parameter == null) {
            StringConverter converter = (StringConverter)this.provider.lookup(String.class);
            for (String value : values) {
                Object converted = converter.stringToObject(value, (Type)((Object)String.class), dynamicAttributes, expression);
                if (converted == null) continue;
                collection.add(converted);
            }
        } else {
            GlobalConverter converter = this.provider.lookup(parameter);
            if (converter == null) {
                throw new ConverterStateException("Unable to convert to the type [" + String.valueOf(convertTo) + "] because the parameter type [" + String.valueOf(parameter) + "] doesn't have a Converter associated with it.");
            }
            for (String value : values) {
                Object converted = converter.convertFromStrings(parameter, dynamicAttributes, expression, value);
                if (converted == null) continue;
                collection.add(converted);
            }
        }
        return collection;
    }
}

