/*
 * Decompiled with CFR 0.152.
 */
package org.primeframework.mvc.parameter;

import com.google.inject.Inject;
import io.fusionauth.http.FileInfo;
import io.fusionauth.http.HTTPMethod;
import io.fusionauth.http.server.HTTPRequest;
import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.primeframework.mvc.action.ActionInvocation;
import org.primeframework.mvc.action.ActionInvocationStore;
import org.primeframework.mvc.action.PreParameterMethodConfiguration;
import org.primeframework.mvc.action.config.ActionConfiguration;
import org.primeframework.mvc.config.MVCConfiguration;
import org.primeframework.mvc.message.MessageStore;
import org.primeframework.mvc.message.MessageType;
import org.primeframework.mvc.message.SimpleFieldMessage;
import org.primeframework.mvc.message.l10n.MessageProvider;
import org.primeframework.mvc.message.l10n.MissingMessageException;
import org.primeframework.mvc.parameter.ParameterHandler;
import org.primeframework.mvc.parameter.ParameterParser;
import org.primeframework.mvc.parameter.convert.ConversionException;
import org.primeframework.mvc.parameter.convert.ConverterStateException;
import org.primeframework.mvc.parameter.convert.MultipleParametersUnsupportedException;
import org.primeframework.mvc.parameter.el.BeanExpressionException;
import org.primeframework.mvc.parameter.el.ExpressionEvaluator;
import org.primeframework.mvc.parameter.el.ExpressionException;
import org.primeframework.mvc.parameter.el.ReadExpressionException;
import org.primeframework.mvc.parameter.fileupload.annotation.FileUpload;
import org.primeframework.mvc.util.ArrayBuilder;
import org.primeframework.mvc.util.ReflectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultParameterHandler
implements ParameterHandler {
    private static final Logger logger = LoggerFactory.getLogger(DefaultParameterHandler.class);
    private final ActionInvocationStore actionInvocationStore;
    private final MVCConfiguration configuration;
    private final ExpressionEvaluator expressionEvaluator;
    private final MessageProvider messageProvider;
    private final MessageStore messageStore;
    private final HTTPRequest request;

    @Inject
    public DefaultParameterHandler(MVCConfiguration configuration, ActionInvocationStore actionInvocationStore, ExpressionEvaluator expressionEvaluator, MessageProvider messageProvider, MessageStore messageStore, HTTPRequest request) {
        this.configuration = configuration;
        this.actionInvocationStore = actionInvocationStore;
        this.expressionEvaluator = expressionEvaluator;
        this.messageProvider = messageProvider;
        this.messageStore = messageStore;
        this.request = request;
    }

    @Override
    public void handle(ParameterParser.Parameters parameters) {
        HTTPMethod method;
        if (logger.isDebugEnabled()) {
            logger.debug("Parameters found [{}] ", (Object)parameters);
        }
        ActionInvocation actionInvocation = this.actionInvocationStore.getCurrent();
        Object action = actionInvocation.action;
        this.setValues(parameters.pre, actionInvocation, true);
        ActionConfiguration actionConfiguration = actionInvocation.configuration;
        if (actionConfiguration.preParameterMethods.size() > 0 && actionConfiguration.preParameterMethods.containsKey(method = this.request.getMethod())) {
            for (PreParameterMethodConfiguration methodConfig : actionConfiguration.preParameterMethods.get(method)) {
                ReflectionUtils.invoke(methodConfig.method, action, new Object[0]);
            }
        }
        this.setValues(parameters.optional, actionInvocation, true);
        this.setValues(parameters.required, actionInvocation, this.configuration.allowUnknownParameters());
        if (parameters.files.size() > 0) {
            this.handleFiles(parameters.files, actionConfiguration, action);
        }
    }

    protected void handleFiles(Map<String, List<FileInfo>> fileInfos, ActionConfiguration actionConfiguration, Object action) {
        if (!this.request.isMultipart()) {
            return;
        }
        long maxSize = this.configuration.fileUploadMaxSize();
        Set<String> allowedContentTypes = this.configuration.fileUploadAllowedTypes();
        for (String key : fileInfos.keySet()) {
            ArrayList list = new ArrayList(fileInfos.get(key));
            FileUpload fileUpload = actionConfiguration.fileUploadMembers.get(key);
            Iterator i = list.iterator();
            while (i.hasNext()) {
                FileInfo info = (FileInfo)i.next();
                if (fileUpload != null && fileUpload.maxSize() != -1L) {
                    maxSize = fileUpload.maxSize();
                }
                try {
                    String contentType;
                    String[] override;
                    long fileSize = Files.size(info.file);
                    if (fileSize > maxSize) {
                        String code = "[fileUploadTooBig]" + key;
                        String message = this.messageProvider.getMessage(code, key, fileSize, maxSize);
                        this.messageStore.add(new SimpleFieldMessage(MessageType.ERROR, key, code, message));
                        i.remove();
                    }
                    Set<String> contentTypesToCheck = allowedContentTypes;
                    if (fileUpload != null && fileUpload.contentTypes().length > 0 && (override = fileUpload.contentTypes()).length > 0) {
                        contentTypesToCheck = Set.of(override);
                    }
                    if (contentTypesToCheck.contains("*") || contentTypesToCheck.contains(contentType = info.contentType)) continue;
                    String code = "[fileUploadBadContentType]" + key;
                    String message = this.messageProvider.getMessage(code, key, contentType, contentTypesToCheck.toArray(new String[0]));
                    this.messageStore.add(new SimpleFieldMessage(MessageType.ERROR, key, code, message));
                    i.remove();
                }
                catch (IOException e) {
                    String code = "[fileUploadFailed]" + key;
                    String message = this.messageProvider.getMessage(code, key);
                    this.messageStore.add(new SimpleFieldMessage(MessageType.ERROR, key, code, message));
                }
            }
            if (list.size() <= 0) continue;
            this.expressionEvaluator.setValue(key, action, list);
        }
    }

    protected void setValues(Map<String, ParameterParser.Parameters.Struct> values, ActionInvocation actionInvocation, boolean allowUnknownParameters) {
        Object action = actionInvocation.action;
        for (String key : values.keySet()) {
            ParameterParser.Parameters.Struct struct = values.get(key);
            if (struct.values == null) continue;
            try {
                this.expressionEvaluator.setValue(key, action, struct.values.toArray(new String[0]), struct.attributes);
            }
            catch (ConversionException ce) {
                this.addCouldNotConvertMessage(key, struct, ce);
            }
            catch (ConverterStateException cse) {
                if (allowUnknownParameters) {
                    logger.debug("Invalid parameter to action [{}]", (Object)action.getClass().getName(), (Object)cse);
                    continue;
                }
                throw cse;
            }
            catch (BeanExpressionException ee) {
                throw ee;
            }
            catch (ExpressionException ee) {
                if (actionInvocation.configuration.unknownParametersField != null) {
                    this.captureUnknownParameter(key, struct, actionInvocation);
                    continue;
                }
                if (allowUnknownParameters || actionInvocation.configuration.allowUnknownParameters) {
                    logger.debug("Invalid parameter to action [" + action.getClass().getName() + "]", (Throwable)ee);
                    continue;
                }
                throw ee;
            }
            catch (MultipleParametersUnsupportedException e) {
                throw new MultipleParametersUnsupportedException(e.getMessage() + " Action class [" + action.getClass().getName() + "] Request URI [" + actionInvocation.actionURI + "] Parameter name [" + key + "]");
            }
        }
    }

    private void addCouldNotConvertMessage(String key, ParameterParser.Parameters.Struct struct, ConversionException ce) {
        String code = "[couldNotConvert]" + key;
        try {
            String message = this.messageProvider.getMessage(code, new ArrayBuilder<String>(String.class, key).addAll((Iterable<String>)struct.values).done());
            this.messageStore.add(new SimpleFieldMessage(MessageType.ERROR, key, code, message));
        }
        catch (MissingMessageException mme) {
            String part = key.replaceAll("\\[.+?]$", "");
            if (!part.equals(key)) {
                try {
                    String modifiedCode = "[couldNotConvert]" + part + "[]";
                    String message = this.messageProvider.getMessage(modifiedCode, new ArrayBuilder<String>(String.class, key).addAll((Iterable<String>)struct.values).done());
                    this.messageStore.add(new SimpleFieldMessage(MessageType.ERROR, key, modifiedCode, message));
                    return;
                }
                catch (MissingMessageException missingMessageException) {
                    // empty catch block
                }
            }
            this.messageStore.add(new SimpleFieldMessage(MessageType.ERROR, key, code, ce.getMessage()));
        }
    }

    private void captureUnknownParameter(String key, ParameterParser.Parameters.Struct struct, ActionInvocation actionInvocation) {
        Field field = actionInvocation.configuration.unknownParametersField;
        try {
            Map unknownParameters = (Map)field.get(actionInvocation.action);
            unknownParameters.put(key, struct.values.toArray(new String[0]));
        }
        catch (IllegalAccessException e) {
            throw new ReadExpressionException("Illegal access for field [" + String.valueOf(field) + "]", e);
        }
    }
}

