/*
 * Decompiled with CFR 0.152.
 */
package org.primeframework.mvc.action.result;

import com.google.inject.Inject;
import io.fusionauth.http.server.HTTPContext;
import java.util.Map;
import java.util.WeakHashMap;
import org.primeframework.mvc.action.ActionInvocation;
import org.primeframework.mvc.action.ActionInvocationStore;
import org.primeframework.mvc.action.result.ResourceLocator;
import org.primeframework.mvc.action.result.ResultStore;

public class DefaultResourceLocator
implements ResourceLocator {
    private static final Map<String, String> resourceCache = new WeakHashMap<String, String>();
    private final ActionInvocationStore actionInvocationStore;
    private final HTTPContext context;
    private final ResultStore resultStore;

    @Inject
    public DefaultResourceLocator(ActionInvocationStore actionInvocationStore, ResultStore resultStore, HTTPContext context) {
        this.context = context;
        this.resultStore = resultStore;
        this.actionInvocationStore = actionInvocationStore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String locate(String directory) {
        ActionInvocation actionInvocation = this.actionInvocationStore.getCurrent();
        String actionURI = actionInvocation.actionURI;
        String extension = actionInvocation.extension;
        String resultCode = this.resultStore.get();
        String key = directory + actionURI + "-" + extension + "-" + resultCode;
        Map<String, String> map = resourceCache;
        synchronized (map) {
            String resource = resourceCache.get(key);
            if (resource != null) {
                return resource;
            }
            if (actionURI.endsWith("/")) {
                resource = this.findResource(directory + actionURI + "index.ftl");
            } else {
                if (extension != null) {
                    if (resultCode != null) {
                        resource = this.findResource(directory + actionURI + "-" + extension + "-" + resultCode + ".ftl");
                    }
                    if (resource == null) {
                        resource = this.findResource(directory + actionURI + "-" + extension + ".ftl");
                    }
                }
                if (resource == null && resultCode != null) {
                    resource = this.findResource(directory + actionURI + "-" + resultCode + ".ftl");
                }
                if (resource == null) {
                    resource = this.findResource(directory + actionURI + ".ftl");
                }
            }
            if (resource != null) {
                resourceCache.put(key, resource);
            }
            return resource;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String locateIndex(String directory) {
        ActionInvocation actionInvocation = this.actionInvocationStore.getCurrent();
        String actionURI = actionInvocation.actionURI;
        String key = directory + actionURI + "/index";
        Map<String, String> map = resourceCache;
        synchronized (map) {
            Object resource = resourceCache.get(key);
            if (resource != null) {
                return resource;
            }
            resource = this.findResource(directory + actionURI + "/index.ftl");
            if (resource != null) {
                resource = actionURI + "/";
                resourceCache.put(key, (String)resource);
            }
            return resource;
        }
    }

    private String findResource(String path) {
        return this.context.getResource(path) != null ? path : null;
    }
}

