/*
 * Decompiled with CFR 0.152.
 */
package org.primeframework.mvc.http;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.primeframework.mvc.http.MultipartFileUpload;
import org.primeframework.mvc.util.EncodingUtils;

public class MultipartBodyHandler {
    public final String boundary = UUID.randomUUID().toString().replace("-", "");
    private final Multiparts request;
    private byte[] body;

    public MultipartBodyHandler(Multiparts multiparts) {
        this.request = multiparts;
    }

    public byte[] getBody() {
        if (this.request.files != null || this.request.parameters != null) {
            this.serializeRequest();
        }
        return this.body;
    }

    private void serializeRequest() {
        if (this.body == null) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(byteArrayOutputStream);
            try {
                if (this.request.files != null) {
                    for (MultipartFileUpload object : this.request.files) {
                        ((Writer)outputStreamWriter).append("--").append(this.boundary).append("\r\n");
                        ((Writer)outputStreamWriter).append("Content-Disposition: form-data; name=\"").append(URLEncoder.encode(object.name, StandardCharsets.UTF_8)).append("\"").append("; filename=\"").append(EncodingUtils.escapedQuotedString((String)object.fileName)).append("\"; filename*=UTF-8''").append(EncodingUtils.rfc5987_encode((String)object.fileName));
                        if (object.contentType != null) {
                            ((Writer)outputStreamWriter).append("\r\nContent-Type: ").append(object.contentType);
                        }
                        ((Writer)outputStreamWriter).append("\r\n\r\n");
                        ((Writer)outputStreamWriter).flush();
                        byteArrayOutputStream.write(Files.readAllBytes(object.file));
                        byteArrayOutputStream.flush();
                        ((Writer)outputStreamWriter).append("\r\n");
                        ((Writer)outputStreamWriter).flush();
                    }
                }
                if (this.request.parameters != null) {
                    for (Map.Entry entry : this.request.parameters.entrySet()) {
                        for (String string : (List)entry.getValue()) {
                            ((Writer)outputStreamWriter).append("--").append(this.boundary).append("\r\n");
                            ((Writer)outputStreamWriter).append("Content-Disposition: form-data; name=\"").append(URLEncoder.encode((String)entry.getKey(), StandardCharsets.UTF_8)).append("\"\r\n\r\n").append(string).append("\r\n");
                        }
                    }
                }
                ((Writer)outputStreamWriter).append("--").append(this.boundary).append("--");
                ((Writer)outputStreamWriter).flush();
                byteArrayOutputStream.flush();
                this.body = byteArrayOutputStream.toByteArray();
            }
            catch (IOException iOException) {
                throw new IllegalStateException(iOException);
            }
        }
    }

    public static class Multiparts {
        public final List<MultipartFileUpload> files;
        public final Map<String, List<String>> parameters;

        public Multiparts(List<MultipartFileUpload> list, Map<String, List<String>> map) {
            this.files = list;
            this.parameters = map;
        }
    }
}

