/*
 * Decompiled with CFR 0.152.
 */
package org.primeframework.mvc.action.result;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.inject.Inject;
import io.fusionauth.http.Cookie;
import io.fusionauth.http.HTTPMethod;
import io.fusionauth.http.server.HTTPRequest;
import io.fusionauth.http.server.HTTPResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.easymock.EasyMock;
import org.primeframework.mvc.PrimeBaseTest;
import org.primeframework.mvc.action.ActionInvocation;
import org.primeframework.mvc.action.ActionInvocationStore;
import org.primeframework.mvc.action.result.SaveRequestResult;
import org.primeframework.mvc.action.result.annotation.SaveRequest;
import org.primeframework.mvc.config.MVCConfiguration;
import org.primeframework.mvc.message.MessageStore;
import org.primeframework.mvc.parameter.el.ExpressionEvaluator;
import org.primeframework.mvc.security.CBCCipherProvider;
import org.primeframework.mvc.security.CipherProvider;
import org.primeframework.mvc.security.DefaultEncryptor;
import org.primeframework.mvc.security.Encryptor;
import org.primeframework.mvc.security.GCMCipherProvider;
import org.primeframework.mvc.security.saved.SavedHttpRequest;
import org.primeframework.mvc.util.CookieTools;
import org.testng.Assert;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class SaveRequestResultTest
extends PrimeBaseTest {
    @Inject
    public ExpressionEvaluator expressionEvaluator;
    @Inject
    public MessageStore messageStore;
    @Inject
    public ObjectMapper objectMapper;

    @DataProvider
    public Object[][] postScenarios() {
        return new Object[][]{{true, "http://localhost"}, {true, "http://myhouse"}, {false, "http://localhost"}, {false, "http://myhouse"}};
    }

    @Test
    public void saveRequestGET() throws Exception {
        ActionInvocationStore actionInvocationStore = (ActionInvocationStore)EasyMock.createStrictMock(ActionInvocationStore.class);
        EasyMock.expect((Object)actionInvocationStore.getCurrent()).andReturn((Object)new ActionInvocation(null, null, "/foo", "", null));
        EasyMock.replay((Object[])new Object[]{actionInvocationStore});
        HTTPRequest hTTPRequest = new HTTPRequest();
        HTTPResponse hTTPResponse = new HTTPResponse();
        hTTPRequest.setPath("/test");
        hTTPRequest.setMethod(HTTPMethod.GET);
        hTTPRequest.addURLParameter("param1", "value1");
        hTTPRequest.addURLParameter("param2", "value2");
        DefaultEncryptor defaultEncryptor = new DefaultEncryptor((CipherProvider)new CBCCipherProvider((MVCConfiguration)configuration), (CipherProvider)new GCMCipherProvider((MVCConfiguration)configuration));
        SaveRequestResult.SaveRequestImpl saveRequestImpl = new SaveRequestResult.SaveRequestImpl("/login", "unauthenticated", true, false, false);
        SaveRequestResult saveRequestResult = new SaveRequestResult(this.messageStore, this.expressionEvaluator, hTTPResponse, hTTPRequest, actionInvocationStore, (MVCConfiguration)configuration, (Encryptor)defaultEncryptor, this.objectMapper);
        saveRequestResult.execute((SaveRequest)saveRequestImpl);
        SavedHttpRequest savedHttpRequest = (SavedHttpRequest)CookieTools.fromJSONCookie((String)((Cookie)hTTPResponse.getCookies().getFirst()).value, SavedHttpRequest.class, (boolean)true, (boolean)true, (Encryptor)defaultEncryptor, (ObjectMapper)this.objectMapper);
        SavedHttpRequest savedHttpRequest2 = new SavedHttpRequest(HTTPMethod.GET, "/test?param1=value1&param2=value2", null);
        Assert.assertEquals((Object)savedHttpRequest, (Object)savedHttpRequest2);
        Assert.assertEquals((String)hTTPResponse.getRedirect(), (String)"/login");
        EasyMock.verify((Object[])new Object[]{actionInvocationStore});
    }

    @Test(dataProvider="postScenarios")
    public void saveRequestPOST(boolean bl, String string) throws Exception {
        ActionInvocationStore actionInvocationStore = (ActionInvocationStore)EasyMock.createStrictMock(ActionInvocationStore.class);
        EasyMock.expect((Object)actionInvocationStore.getCurrent()).andReturn((Object)new ActionInvocation(null, null, "/foo", "", null));
        EasyMock.replay((Object[])new Object[]{actionInvocationStore});
        HTTPRequest hTTPRequest = new HTTPRequest();
        HTTPResponse hTTPResponse = new HTTPResponse();
        hTTPRequest.setScheme("http");
        hTTPRequest.setHost("localhost");
        hTTPRequest.setPath("/test");
        hTTPRequest.setMethod(HTTPMethod.POST);
        hTTPRequest.addURLParameter("param1", "value1");
        hTTPRequest.addURLParameter("param2", "value2");
        hTTPRequest.addHeader("Origin", string);
        DefaultEncryptor defaultEncryptor = new DefaultEncryptor((CipherProvider)new CBCCipherProvider((MVCConfiguration)configuration), (CipherProvider)new GCMCipherProvider((MVCConfiguration)configuration));
        SaveRequestResult.SaveRequestImpl saveRequestImpl = new SaveRequestResult.SaveRequestImpl("/login", "unauthenticated", true, false, bl);
        SaveRequestResult saveRequestResult = new SaveRequestResult(this.messageStore, this.expressionEvaluator, hTTPResponse, hTTPRequest, actionInvocationStore, (MVCConfiguration)configuration, (Encryptor)defaultEncryptor, this.objectMapper);
        saveRequestResult.execute((SaveRequest)saveRequestImpl);
        if (bl && string.equals(hTTPRequest.getBaseURL())) {
            SavedHttpRequest savedHttpRequest = (SavedHttpRequest)CookieTools.fromJSONCookie((String)((Cookie)hTTPResponse.getCookies().getFirst()).value, SavedHttpRequest.class, (boolean)true, (boolean)true, (Encryptor)defaultEncryptor, (ObjectMapper)this.objectMapper);
            SavedHttpRequest savedHttpRequest2 = new SavedHttpRequest(HTTPMethod.POST, "/test", hTTPRequest.getParameters());
            Assert.assertEquals((Object)savedHttpRequest, (Object)savedHttpRequest2);
        } else {
            Assert.assertEquals((Collection)hTTPResponse.getCookies(), List.of());
        }
        Assert.assertEquals((String)hTTPResponse.getRedirect(), (String)"/login");
        EasyMock.verify((Object[])new Object[]{actionInvocationStore});
    }

    @Test
    public void saveRequestPOST_tooBig() throws IOException {
        ActionInvocationStore actionInvocationStore = (ActionInvocationStore)EasyMock.createStrictMock(ActionInvocationStore.class);
        HashMap<String, ArrayList<String>> hashMap = new HashMap<String, ArrayList<String>>();
        hashMap.put("largeParam1", new ArrayList<String>(List.of(new String(new char[2048]).replace('\u0000', 'a'))));
        hashMap.put("largeParam2", new ArrayList<String>(List.of(new String(new char[2048]).replace('\u0000', 'b'))));
        hashMap.put("largeParam3", new ArrayList<String>(List.of(new String(new char[2048]).replace('\u0000', 'c'))));
        hashMap.put("largeParam4", new ArrayList<String>(List.of(new String(new char[2048]).replace('\u0000', 'd'))));
        EasyMock.expect((Object)actionInvocationStore.getCurrent()).andReturn((Object)new ActionInvocation(null, null, "/foo", "", hashMap, null, true));
        EasyMock.replay((Object[])new Object[]{actionInvocationStore});
        HTTPRequest hTTPRequest = new HTTPRequest();
        HTTPResponse hTTPResponse = new HTTPResponse();
        hTTPRequest.setPath("/test");
        hTTPRequest.setMethod(HTTPMethod.POST);
        hTTPRequest.addURLParameter("largeParam1", (String)((List)hashMap.get("largeParam1")).getFirst());
        hTTPRequest.addURLParameter("largeParam2", (String)((List)hashMap.get("largeParam2")).getFirst());
        hTTPRequest.addURLParameter("largeParam3", (String)((List)hashMap.get("largeParam3")).getFirst());
        hTTPRequest.addURLParameter("largeParam4", (String)((List)hashMap.get("largeParam4")).getFirst());
        DefaultEncryptor defaultEncryptor = new DefaultEncryptor((CipherProvider)new CBCCipherProvider((MVCConfiguration)configuration), (CipherProvider)new GCMCipherProvider((MVCConfiguration)configuration));
        SaveRequestResult.SaveRequestImpl saveRequestImpl = new SaveRequestResult.SaveRequestImpl("/login", "unauthenticated", true, false, false);
        SaveRequestResult saveRequestResult = new SaveRequestResult(this.messageStore, this.expressionEvaluator, hTTPResponse, hTTPRequest, actionInvocationStore, (MVCConfiguration)configuration, (Encryptor)defaultEncryptor, this.objectMapper);
        saveRequestResult.execute((SaveRequest)saveRequestImpl);
        Assert.assertEquals(SaveRequestResultTest.simulator.userAgent.getCookies(hTTPRequest), List.of());
        Assert.assertEquals((String)hTTPResponse.getRedirect(), (String)"/login");
        EasyMock.verify((Object[])new Object[]{actionInvocationStore});
    }
}

