/*
 * Decompiled with CFR 0.152.
 */
package org.primeframework.mvc;

import com.codahale.metrics.MetricRegistry;
import com.google.inject.AbstractModule;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.util.Modules;
import io.fusionauth.http.server.HTTPListenerConfiguration;
import io.fusionauth.http.server.HTTPRequest;
import io.fusionauth.http.server.HTTPResponse;
import io.fusionauth.http.server.HTTPServerConfiguration;
import java.util.List;
import java.util.UUID;
import org.example.action.oauth.TokenAction;
import org.primeframework.mvc.PrimeBaseTest;
import org.primeframework.mvc.TestPrimeMain;
import org.primeframework.mvc.cors.CORSConfigurationProvider;
import org.primeframework.mvc.cors.NoCORSConfigurationProvider;
import org.primeframework.mvc.guice.MVCModule;
import org.primeframework.mvc.http.HTTPObjectsHolder;
import org.primeframework.mvc.jwt.MockVerifierProvider;
import org.primeframework.mvc.message.MessageObserver;
import org.primeframework.mvc.message.TestMessageObserver;
import org.primeframework.mvc.message.scope.ApplicationScope;
import org.primeframework.mvc.message.scope.CookieFlashScope;
import org.primeframework.mvc.message.scope.FlashScope;
import org.primeframework.mvc.message.scope.RequestScope;
import org.primeframework.mvc.security.MockOAuthUserLoginSecurityContext;
import org.primeframework.mvc.security.UserLoginSecurityContext;
import org.primeframework.mvc.security.VerifierProvider;
import org.primeframework.mvc.security.oauth.TokenAuthenticationMethod;
import org.primeframework.mvc.test.RequestSimulator;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class JWTRefreshTokenLoginTest {
    protected static final TestMessageObserver messageObserver = new TestMessageObserver();
    protected static final MetricRegistry metricRegistry = new MetricRegistry();
    public static Injector injector;
    public HTTPRequest request;
    public HTTPResponse response;
    public RequestSimulator simulator;

    @AfterClass
    public void afterClass() {
        this.simulator.shutdown();
    }

    @AfterMethod
    public void afterMethod() {
        HTTPObjectsHolder.clearRequest();
        HTTPObjectsHolder.clearResponse();
    }

    @BeforeClass
    public void beforeClass() {
        MVCModule mVCModule = new MVCModule(this){

            protected void configure() {
                super.configure();
                this.install((Module)new PrimeBaseTest.TestMVCConfigurationModule());
                this.bind(MessageObserver.class).toInstance((Object)messageObserver);
                this.bind(MetricRegistry.class).toInstance((Object)metricRegistry);
                this.bind(UserLoginSecurityContext.class).to(MockOAuthUserLoginSecurityContext.class);
                this.bind(CORSConfigurationProvider.class).to(NoCORSConfigurationProvider.class);
            }
        };
        Module module = Modules.override((Module[])new Module[]{mVCModule}).with(new Module[]{new PrimeBaseTest.TestContentModule(), new TestSecurityModule(), new TestScopeModule()});
        HTTPServerConfiguration hTTPServerConfiguration = new HTTPServerConfiguration().withListener(new HTTPListenerConfiguration(9081));
        TestPrimeMain testPrimeMain = new TestPrimeMain(new HTTPServerConfiguration[]{hTTPServerConfiguration}, module);
        this.simulator = new RequestSimulator(testPrimeMain, messageObserver);
        injector = this.simulator.getInjector();
    }

    @BeforeMethod
    public void beforeMethod() {
        this.request = new HTTPRequest();
        this.response = new HTTPResponse();
        HTTPObjectsHolder.setRequest((HTTPRequest)this.request);
        HTTPObjectsHolder.setResponse((HTTPResponse)this.response);
        this.simulator.userAgent.reset();
        messageObserver.reset();
        MockOAuthUserLoginSecurityContext.Roles.clear();
        MockOAuthUserLoginSecurityContext.CurrentUser = null;
        MockOAuthUserLoginSecurityContext.reset();
    }

    @Test
    public void login() {
        this.simulator.test("/oauth/login").post().assertStatusCode(200);
        this.simulator.test("/oauth/protected-resource").get().assertStatusCode(200).assertBodyContains("Logged in");
    }

    @Test
    public void login_expired() {
        this.simulator.test("/oauth/login").withParameter("expired", "true").post().assertStatusCode(401);
    }

    @Test
    public void notLoggedIn() {
        this.simulator.test("/oauth/protected-resource").get().assertStatusCode(302).assertRedirect("/oauth/login");
    }

    @Test
    public void refreshTokenEndpointDown() {
        MockOAuthUserLoginSecurityContext.ValidateJWTOnLogin = false;
        this.simulator.test("/oauth/login").withParameter("expired", "true").post().assertStatusCode(200);
        this.simulator.test("/oauth/protected-resource").get().assertStatusCode(302).assertRedirect("/oauth/login");
    }

    @Test
    public void refreshTokenEndpointUp_auth_client_secret_basic() {
        MockOAuthUserLoginSecurityContext.tokenAuthenticationMethod = TokenAuthenticationMethod.client_secret_basic;
        MockOAuthUserLoginSecurityContext.clientId = "the client ID";
        MockOAuthUserLoginSecurityContext.clientSecret = "the client secret";
        MockOAuthUserLoginSecurityContext.ValidateJWTOnLogin = false;
        MockOAuthUserLoginSecurityContext.TokenEndpoint = "http://localhost:" + this.simulator.getPort() + "/oauth/token";
        this.simulator.test("/oauth/login").withParameter("expired", "true").post().assertStatusCode(200);
        this.simulator.test("/oauth/protected-resource").get().assertStatusCode(200).assertBodyContains("Logged in");
    }

    @Test
    public void refreshTokenEndpointUp_auth_client_secret_basic_colon_in_client_id() {
        MockOAuthUserLoginSecurityContext.tokenAuthenticationMethod = TokenAuthenticationMethod.client_secret_basic;
        MockOAuthUserLoginSecurityContext.clientId = "the:client ID";
        MockOAuthUserLoginSecurityContext.clientSecret = "the client secret";
        MockOAuthUserLoginSecurityContext.ValidateJWTOnLogin = false;
        MockOAuthUserLoginSecurityContext.TokenEndpoint = "http://localhost:" + this.simulator.getPort() + "/oauth/token";
        this.simulator.test("/oauth/login").withParameter("expired", "true").post().assertStatusCode(200);
        this.simulator.test("/oauth/protected-resource").get().assertStatusCode(302).assertRedirect("/oauth/login");
    }

    @Test
    public void refreshTokenEndpointUp_auth_client_secret_post() {
        MockOAuthUserLoginSecurityContext.tokenAuthenticationMethod = TokenAuthenticationMethod.client_secret_post;
        MockOAuthUserLoginSecurityContext.clientId = "the client ID";
        MockOAuthUserLoginSecurityContext.clientSecret = "the client secret";
        MockOAuthUserLoginSecurityContext.ValidateJWTOnLogin = false;
        MockOAuthUserLoginSecurityContext.TokenEndpoint = "http://localhost:" + this.simulator.getPort() + "/oauth/token";
        this.simulator.test("/oauth/login").withParameter("expired", "true").post().assertStatusCode(200);
        this.simulator.test("/oauth/protected-resource").get().assertStatusCode(200).assertBodyContains("Logged in");
    }

    @Test
    public void refreshTokenEndpointUp_no_auth() {
        MockOAuthUserLoginSecurityContext.ValidateJWTOnLogin = false;
        MockOAuthUserLoginSecurityContext.TokenEndpoint = "http://localhost:" + this.simulator.getPort() + "/oauth/token";
        this.simulator.test("/oauth/login").withParameter("expired", "true").post().assertStatusCode(200);
        this.simulator.test("/oauth/protected-resource").get().assertStatusCode(200).assertBodyContains("Logged in");
    }

    @Test
    public void refreshTokenEndpoint_additionalParameters() {
        String string = new UUID(5L, 0L).toString();
        MockOAuthUserLoginSecurityContext.additionalParameters.put("tenantId", List.of(string));
        MockOAuthUserLoginSecurityContext.TokenEndpoint = "http://localhost:" + this.simulator.getPort() + "/oauth/token";
        MockOAuthUserLoginSecurityContext.ValidateJWTOnLogin = false;
        this.simulator.test("/oauth/login").withParameter("expired", "true").post().assertStatusCode(200);
        this.simulator.test("/oauth/protected-resource").get().assertStatusCode(200).assertBodyContains("Logged in");
        Assert.assertTrue((boolean)TokenAction.UnknownParameters.containsKey("tenantId"), (String)"Missing tenantId in unknown parameters");
        Assert.assertEquals((Object[])TokenAction.UnknownParameters.get("tenantId"), (Object[])new String[]{string}, (String)"Mismatched tenantId in unknown parameters");
    }

    public static class TestSecurityModule
    extends AbstractModule {
        protected void configure() {
            this.bind(VerifierProvider.class).to(MockVerifierProvider.class);
        }
    }

    public static class TestScopeModule
    extends AbstractModule {
        protected void configure() {
            this.bind(ApplicationScope.class).asEagerSingleton();
            this.bind(RequestScope.class);
            this.bind(FlashScope.class).toProvider(() -> (FlashScope)injector.getInstance(CookieFlashScope.class));
        }
    }
}

