/*
 * Decompiled with CFR 0.152.
 */
package org.primeframework.mvc.security;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.ZonedDateTime;
import java.util.UUID;
import org.primeframework.mvc.security.UserIdSessionContext;

public class MockUserIdSessionContext
implements UserIdSessionContext<UUID> {
    @JsonProperty
    private String loginInstant;
    @JsonProperty
    private String sessionId;
    @JsonProperty
    private UUID userId;

    public MockUserIdSessionContext(UUID uUID, ZonedDateTime zonedDateTime) {
        this.sessionId = UUID.randomUUID().toString();
        this.userId = uUID;
        this.loginInstant = zonedDateTime.toString();
    }

    @JsonCreator
    private MockUserIdSessionContext() {
    }

    @JsonIgnore
    public ZonedDateTime getLoginInstant() {
        return ZonedDateTime.parse(this.loginInstant);
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public UUID getUserId() {
        return this.userId;
    }
}

