/*
 * Decompiled with CFR 0.152.
 */
package org.primeframework.mvc;

import com.google.inject.Module;
import com.google.inject.util.Modules;
import io.fusionauth.http.server.HTTPListenerConfiguration;
import io.fusionauth.http.server.HTTPRequest;
import io.fusionauth.http.server.HTTPResponse;
import io.fusionauth.http.server.HTTPServerConfiguration;
import org.primeframework.mvc.MockConfiguration;
import org.primeframework.mvc.PrimeBaseTest;
import org.primeframework.mvc.TestPrimeMain;
import org.primeframework.mvc.config.MVCConfiguration;
import org.primeframework.mvc.cors.CORSConfigurationProvider;
import org.primeframework.mvc.cors.NoCORSConfigurationProvider;
import org.primeframework.mvc.guice.MVCModule;
import org.primeframework.mvc.http.HTTPObjectsHolder;
import org.primeframework.mvc.security.MockOAuthUserLoginSecurityContext;
import org.primeframework.mvc.security.UserLoginSecurityContext;
import org.primeframework.mvc.test.RequestSimulator;
import org.testng.annotations.AfterClass;
import org.testng.annotations.Test;

public class MultipleServerTest {
    public RequestSimulator simulator;

    @AfterClass
    public void afterClass() {
        if (this.simulator != null) {
            this.simulator.shutdown();
        }
        HTTPObjectsHolder.clearRequest();
        HTTPObjectsHolder.clearResponse();
    }

    @Test
    public void multipleServers() {
        HTTPObjectsHolder.setRequest((HTTPRequest)new HTTPRequest());
        HTTPObjectsHolder.setResponse((HTTPResponse)new HTTPResponse());
        MVCModule mVCModule = new MVCModule(this){

            protected void configure() {
                super.configure();
                this.bind(MVCConfiguration.class).toInstance((Object)new MockConfiguration());
                this.bind(UserLoginSecurityContext.class).to(MockOAuthUserLoginSecurityContext.class);
                this.bind(CORSConfigurationProvider.class).to(NoCORSConfigurationProvider.class);
            }
        };
        Module module = Modules.override((Module[])new Module[]{mVCModule}).with(new Module[]{new PrimeBaseTest.TestContentModule()});
        HTTPServerConfiguration hTTPServerConfiguration = new HTTPServerConfiguration().withListener(new HTTPListenerConfiguration(9082));
        HTTPServerConfiguration hTTPServerConfiguration2 = new HTTPServerConfiguration().withListener(new HTTPListenerConfiguration(9083));
        TestPrimeMain testPrimeMain = new TestPrimeMain(new HTTPServerConfiguration[]{hTTPServerConfiguration, hTTPServerConfiguration2}, module);
        this.simulator = new RequestSimulator(testPrimeMain, PrimeBaseTest.messageObserver, 9082);
        this.simulator.test("/port").get().assertStatusCode(200).assertBody("9082");
        this.simulator.port = 9083;
        this.simulator.test("/port").get().assertStatusCode(200).assertBody("9083");
    }
}

