/*
 * Decompiled with CFR 0.152.
 */
package org.primeframework.mvc.security;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import java.security.GeneralSecurityException;
import java.security.SecureRandom;
import java.util.Arrays;
import javax.crypto.Cipher;
import org.primeframework.mvc.security.CipherProvider;
import org.primeframework.mvc.security.Encryptor;

public class DefaultEncryptor
implements Encryptor {
    private final CipherProvider cbcCipherProvider;
    private final CipherProvider gcmCipherProvider;

    @Inject
    public DefaultEncryptor(@Named(value="CBC") CipherProvider cbcCipherProvider, @Named(value="GCM") CipherProvider gcmCipherProvider) {
        this.cbcCipherProvider = cbcCipherProvider;
        this.gcmCipherProvider = gcmCipherProvider;
    }

    @Override
    public byte[] decrypt(byte[] bytes) throws Exception {
        byte[] iv = Arrays.copyOfRange(bytes, 0, 16);
        byte[] encryptedBytes = Arrays.copyOfRange(bytes, 16, bytes.length);
        try {
            Cipher cipher = this.gcmCipherProvider.getDecryptor(iv);
            return this.doDecrypt(encryptedBytes, cipher);
        }
        catch (GeneralSecurityException gcmException) {
            try {
                Cipher cipher = this.cbcCipherProvider.getDecryptor(iv);
                return this.doDecrypt(encryptedBytes, cipher);
            }
            catch (GeneralSecurityException cbcException) {
                throw gcmException;
            }
        }
    }

    @Override
    public byte[] encrypt(byte[] bytes) throws Exception {
        byte[] iv = new byte[16];
        new SecureRandom().nextBytes(iv);
        Cipher cipher = this.gcmCipherProvider.getEncryptor(iv);
        return this.doEncrypt(bytes, cipher);
    }

    private byte[] doDecrypt(byte[] bytes, Cipher cipher) throws GeneralSecurityException {
        byte[] result = new byte[cipher.getOutputSize(bytes.length)];
        int resultLength = cipher.update(bytes, 0, bytes.length, result, 0);
        resultLength += cipher.doFinal(result, resultLength);
        return Arrays.copyOfRange(result, 0, resultLength);
    }

    private byte[] doEncrypt(byte[] bytes, Cipher cipher) throws GeneralSecurityException {
        byte[] result = new byte[cipher.getOutputSize(bytes.length)];
        int resultLength = cipher.update(bytes, 0, bytes.length, result, 0);
        resultLength += cipher.doFinal(result, resultLength);
        byte[] iv = cipher.getIV();
        byte[] combined = new byte[iv.length + resultLength];
        System.arraycopy(iv, 0, combined, 0, iv.length);
        System.arraycopy(result, 0, combined, iv.length, resultLength);
        return combined;
    }
}

